<?php

namespace App\Http\Controllers\Api\App;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Laravel\Passport\Client;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Models\User;
use Exception;

class AuthController extends Controller
{
    public function login(Request $request){
        try {
            $user = User::whereNotNull('uuid')->where('uuid', $request->uuid)->first();
            if (!$user) {
                throw new Exception('Unauthorized: incorrect account/password', 401);
            }
            
            $token = $user->api_token;

            return response()->json(['success' => true, 'token' => $token]);

        }  catch (Exception $e) {
            $statusCode = $e->getCode() ? $e->getCode() : 500;
            $message = $e->getMessage();

            return response()->json(['error' => $message], $statusCode);
        }
    }
}