<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CheckList;
use App\Models\CheckBankDetail;
use App\Models\CheckPhoto;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class CheckBankDetailController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $check_id = $request->query('check_id');

        $detailData = CheckBankDetail::with(['photos' => function ($q) {
            $q->whereNotNull('file_path')->whereNull('deleted_at');
        }])->where('check_id' , $check_id)->orderby('id')->get();
        $listData = CheckList::with(['equipment.category', 'equipment.factory'])->where('id',$check_id)->get();

        return response()->json(["detailData" => $detailData , 'listData' => $listData], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(CheckBankDetail $checkBankDetail)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CheckBankDetail $checkBankDetail)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $check_id)
    {   
        $detailData = $request->input('details');
        $action = $request->input('action');
        DB::beginTransaction();
        try {
            foreach ($detailData as $index => $data) {
                $detail = CheckBankDetail::findOrFail($data['id']);
                $detail->update([
                    'remark' => $data['remark'],
                    'option_state' => $data['option_state'],
                    'option_input' => $data['option_input'],
                ]);
            }
            $checklist = CheckList::find($check_id);
            if($action === 'commit'){ 
                $checklist->update([
                    'finish_user_id' => Auth::user()->id,
                    'state' => 0
                ]);
            }else if($action === 'save'){
                $checklist->update([
                    'state' => 2
                ]);
            }

            DB::commit();
            return response()->json(['message' => '資料儲存成功']);
        } catch (Exception $e) {
            DB::rollback();
            throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CheckBankDetail $checkBankDetail)
    {
        //
    }

    public function uploadPhotos(Request $request)
    {
        $check_id = json_decode($request->input('check_id'));
        $ids = json_decode($request->input('ids'), true);
        if (!$ids || !is_array($ids)) {
            return response()->json(['message' => '缺少 ids'], 422);
        }
        DB::beginTransaction();
        try {
            foreach ($ids as $itemIndex => $detailId) {
                for ($photoIndex = 0; $photoIndex < 3; $photoIndex++) {
                    $photoKey = "photos_{$itemIndex}_{$photoIndex}";
                    if ($request->hasFile($photoKey)) {
                        $file = $request->file($photoKey);
                        $path = $file->store("check_images/C{$check_id}/D{$detailId}", 'public');
                        $relativePath = "/storage/" . $path;
                        CheckPhoto::create([
                            'check_detail_id' => $detailId,
                            'photo_index' => $photoIndex,
                            'file_path' => $relativePath,
                        ]);
                    }
                }
            }
            DB::commit();
            return response()->json(['message' => '圖片上傳成功']);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['message' => '圖片上傳失敗', 'error' => $e->getMessage()], 500);
        }
    }


    /*
        刪除圖片後續需要改方法，改的方法如下
        **需建立一張表為圖片歷史紀錄表(photo_record)，用在刪除圖片時，存歷史紀錄，並定訂存活時間，時間到自動刪，流程大致如下
            1.將圖從photo表刪掉(非軟刪除)，到photo_record建立一筆同樣資料
            2.針對建立時間，一個月後自動刪除。
    */
    public function removePhoto(string $check_detail_id, string $photo_id )
    {
        DB::beginTransaction();
        try {
            $photo = CheckPhoto::where('check_detail_id',$check_detail_id)->where('id' ,$photo_id)->first();
            if($photo){
                $photo->forceDelete();
                if($photo->file_path && file_exists(public_path($photo->file_path))){
                    unlink(public_path($photo->file_path));
                }
                DB::commit();
                return response()->json(['mesage' => 'photo deleted'], 200);
            }else{
                return response()->json([
                    'mesage' => 'photo not found' , 
                    // 'itemIndex' => (int)$index-1 , 
                    // 'photoIndex' => (int)$photoIndex
                ], 400);
            }
        } catch (Exception $e) {
            throw $e;
            DB::rollback();
        }
    }
}