<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CheckList;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class CheckListController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $date = now()->toDateString();
        // 稽核單資料
        $checkData = CheckList::with(['equipment.category','equipment.factory' , 'user'])
            ->where(function($query) {
                $userId = Auth::user()->id;
                $query->where('checker_id',$userId)
                    ->orWhere('creator',$userId);
            })
            // ->whereDate('startdate', '<=', $date)
            // ->whereDate('enddate', '>=', $date)
            ->orderBy('id')
            ->get();
        return response()->json(['data' => $checkData ], 200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(CheckList $checkList)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CheckList $checkList)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, CheckList $checkList)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CheckList $checkList)
    {
        //
    }
}