<?php

namespace App\Models;

use App\Models\BankList;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankDetail extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $guared = [];
    protected $fillable = [
        'bank_id',
        'eq_cat_id',
        'code',
        'item',
        'value',
        'range',
        'range2',
        'unit',
        'risk',
        'sort_id',
        'remark',
        'creator',
    ];
    
    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function bankList()
    {
        return $this->belongsTo(BankList::class, 'bank_id');
    }
}
