<?php

namespace App\Models;

use App\Models\Equipment;
use App\Models\BankDetail;
use App\Models\DispatchSet;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BankList extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'eq_id',
        'creator',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function equipment()
    {
        return $this->belongsTo(Equipment::class, 'eq_id');
    }

    public function details()
    {
        return $this->hasMany(BankDetail::class, 'bank_id');
    }

    public function dispatches()
    {
        return $this->hasMany(DispatchSet::class, 'bank_id');
    }
}
