<?php

namespace App\Models;

use App\Models\User;
use App\Models\CheckPhoto;
use App\Models\CheckList;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CheckBankDetail extends Model
{
    use HasFactory;
    
   protected $fillable = [
        'check_id' ,
        'code',
        'item',
        'range',
        'range2',
        'unit',
        'risk',
        'remark',
        'option_state',
        'option_input',
    ];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function photos()
    {
        return $this->hasMany(CheckPhoto::class, 'check_detail_id')->orderBy('photo_index');
    }

    public function checklist()
    {
        return $this->belongsTo(CheckList::class, 'id');
    }

}
