<?php

namespace App\Models;

use App\Models\User;
use App\Models\Equipment;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class CheckList extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = [
      'checker_id' ,
      'eq_id' ,
      'startdate' ,
      'enddate'  ,
      'cycle' ,
      'state' ,
      'finish_user_id' ,
      'creator',
      'created_at' ,
      'updated_at'
    ];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
        'startdate'  => 'datetime:Y-m-d',
        'enddate'   => 'datetime:Y-m-d',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'checker_id');
    }

    public function equipment()
    {
        return $this->belongsTo(Equipment::class, 'eq_id');
    }
}
