<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Daily extends Model
{
    use HasFactory;

    protected $fillable = [
        'remark',
        'creator',
        'created_at',
        'updated_at',
    ];
    
    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];


    public function photos()
    {
        return $this->hasMany(DailyPhoto::class, 'daily_id')->orderBy('photo_index');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'creator');
    }
}
