<?php

namespace App\Models;

use App\Models\BankList;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Carbon;


class DispatchSet extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
       'bank_id' ,
       'checker_id' ,
       'startdate' ,
       'nextdate' ,
       'cycle' ,
       'state' ,
       'creator' ,
       'created_at' ,
       'updated_at'
    ];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
        'startdate'  => 'datetime:Y-m-d',
        'nextdate'   => 'datetime:Y-m-d',
    ];

    public function banklist()
    {
        return $this->belongsTo(BankList::class, 'bank_id');
    }

    public function checker()
    {
        return $this->belongsTo(User::class, 'checker_id');
    }

}
