<?php

namespace App\Models;
     
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Equipment extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function category()
    {
        return $this->belongsTo(EquipmentCategory::class, 'eq_cat_id');
    }

    public function bankLists()
    {
        return $this->hasMany(BankList::class, 'eq_id');
    }

    public function factory()
    {
        return $this->belongsTo(Factory::class, 'factory_id');
    }
}
