<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EquipmentBank extends Model
{
    use HasFactory, SoftDeletes;

    protected $guared = [];
    protected $fillable = [
        'eq_cat_id',
        'code',
        'item',
        'range',
        'range2',
        'unit',
        'risk',
        'sort_id',
        'remark',
        'creator',
    ];
 
    public function category(){
        return $this->belongsTo(EquipmentCategory::class, 'eq_cat_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'creator');
    }
}
