<?php

namespace App\Models;

use App\Models\EquipmentBank;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EquipmentCategory extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];
    public function banks()
    {
        return $this->hasMany(EquipmentBank::class, 'eq_cat_id'); // 例如：設備類別下有哪些項目
    }
}
