<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

class EquipmentRecord extends Model
{
    use HasFactory;

    protected $guarded = [];

    /**
     * [state]
     * 0 => 刪除
     * 1 => 新增
     * 2 => 修改
     */

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function category()
    {
        return $this->belongsTo(EquipmentCategory::class, 'eq_cat_id');
    }

    public function factory()
    {
        return $this->belongsTo(Factory::class, 'factory_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'creator');
    }
}
