<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\FactoryUser;
use App\Models\Equipment;

class Factory extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = [
        'name',
        'creator'
    ];
    
    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function equipment()
    {
        return $this->hasMany(Equipment::class, 'factory_id');
    }
}
