<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equipment_records', function (Blueprint $table) {
            $table->id();
            $table->integer('eq_id');
            $table->string('code');
            $table->string('name');
            $table->integer('eq_cat_id');
            $table->integer('factory_id');
            $table->string('department')->nullable();
            $table->text('remark')->nullable();
            $table->integer('state');
            $table->integer('creator');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipment_records');
    }
};
