<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('check_bank_details', function (Blueprint $table) {
            $table->id();
            $table->integer('check_id');
            $table->string('code');
            $table->string('item');
            $table->float('range')->nullable();
            $table->float('range2')->nullable();
			$table->string('unit')->nullable();
			$table->string('remark')->nullable();
            $table->integer('risk')->nullable();
            $table->integer('option_state')->nullable();
            $table->string('option_input')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('check_bank_details');
    }
};