<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equipment_banks', function (Blueprint $table) {
            $table->id();
            $table->integer('eq_cat_id');
            $table->string('code');
            $table->string('item');
            $table->float('range')->nullable();
            $table->float('range2')->nullable();
            $table->string('unit')->nullable();
            $table->integer('risk');
            $table->integer('sort_id');
            $table->string('remark')->nullable();
            $table->integer('creator');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipment_banks');
    }
};