<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\User;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
       User::insert([
        [
            'uuid' => 'QweVbk6O285ztLA716xTet6d1J6h8ZbiLZ4ZmQQdO0kwVP1rsn0j9mG0gtZrKKEK',
            'email' => 'test@test.com',
            'name' => '總管理員',
            'contact_name' => '總管理員',
            'phone' => '0987654321',
            'tax_number' => '00000000',
            'belongs_parent' => null,
            'role' => 'company',
            'expiry_date' => null,
            'api_token' => Str::random(64),
            'email_verified_at' => Carbon::now(),
        ],
        [
            'uuid' => 'qqqq',
            'email' => 'qqqq@test.com',
            'name' => '測試員',
            'contact_name' => '測試員',
            'phone' => '1234567890',
            'tax_number' => '11111111',
            'belongs_parent' => 1,
            'role' => 'checker',
            'expiry_date' => null,
            'api_token' => Str::random(64),
            'email_verified_at' => Carbon::now(),
        ],
        [
            'uuid' => 'wwww',
            'email' => 'wwww@test.com',
            'name' => '大王',
            'contact_name' => '大王',
            'phone' => '2345678901',
            'tax_number' => '22222222',
            'belongs_parent' => null,
            'role' => 'company',
            'expiry_date' => null,
            'api_token' => Str::random(64),
            'email_verified_at' => Carbon::now(),
        ],
        [
            'uuid' => 'eeee',
            'email' => 'eeee@test.com',
            'name' => '小王',
            'contact_name' => '小王',
            'phone' => '3456789012',
            'tax_number' => '33333333',
            'belongs_parent' => 3,
            'role' => 'checker',
            'expiry_date' => null,
            'api_token' => Str::random(64),
            'email_verified_at' => Carbon::now(),
        ],
        [
            'uuid' => 'aaaa',
            'email' => 'aaaa@test.com',
            'name' => 'A測試員',
            'contact_name' => 'A測試員',
            'phone' => '4567891230',
            'tax_number' => '44444444',
            'belongs_parent' => 1,
            'role' => 'checker',
            'expiry_date' => null,
            'api_token' => Str::random(64),
            'email_verified_at' => Carbon::now(),
        ],
        ]);
    }
}