import { removeClass, addClass } from '@primeuix/utils/dom';
import PlusIcon from '@primevue/icons/plus';
import TimesIcon from '@primevue/icons/times';
import UploadIcon from '@primevue/icons/upload';
import Button from 'primevue/button';
import Message from 'primevue/message';
import ProgressBar from 'primevue/progressbar';
import Ripple from 'primevue/ripple';
import BaseComponent from '@primevue/core/basecomponent';
import FileUploadStyle from 'primevue/fileupload/style';
import Badge from 'primevue/badge';
import { resolveComponent, createElementBlock, openBlock, Fragment, renderList, mergeProps, createElementVNode, createVNode, toDisplayString, normalizeClass, withCtx, createBlock, resolveDynamicComponent, createCommentVNode, renderSlot, withKeys, createTextVNode, normalizeProps } from 'vue';

var script$2 = {
  name: 'BaseFileUpload',
  "extends": BaseComponent,
  props: {
    name: {
      type: String,
      "default": null
    },
    url: {
      type: String,
      "default": null
    },
    mode: {
      type: String,
      "default": 'advanced'
    },
    multiple: {
      type: Boolean,
      "default": false
    },
    accept: {
      type: String,
      "default": null
    },
    disabled: {
      type: Boolean,
      "default": false
    },
    auto: {
      type: Boolean,
      "default": false
    },
    maxFileSize: {
      type: Number,
      "default": null
    },
    invalidFileSizeMessage: {
      type: String,
      "default": '{0}: Invalid file size, file size should be smaller than {1}.'
    },
    invalidFileTypeMessage: {
      type: String,
      "default": '{0}: Invalid file type, allowed file types: {1}.'
    },
    fileLimit: {
      type: Number,
      "default": null
    },
    invalidFileLimitMessage: {
      type: String,
      "default": 'Maximum number of files exceeded, limit is {0} at most.'
    },
    withCredentials: {
      type: Boolean,
      "default": false
    },
    previewWidth: {
      type: Number,
      "default": 50
    },
    chooseLabel: {
      type: String,
      "default": null
    },
    uploadLabel: {
      type: String,
      "default": null
    },
    cancelLabel: {
      type: String,
      "default": null
    },
    customUpload: {
      type: Boolean,
      "default": false
    },
    showUploadButton: {
      type: Boolean,
      "default": true
    },
    showCancelButton: {
      type: Boolean,
      "default": true
    },
    chooseIcon: {
      type: String,
      "default": undefined
    },
    uploadIcon: {
      type: String,
      "default": undefined
    },
    cancelIcon: {
      type: String,
      "default": undefined
    },
    style: null,
    "class": null,
    chooseButtonProps: {
      type: null,
      "default": null
    },
    uploadButtonProps: {
      type: Object,
      "default": function _default() {
        return {
          severity: 'secondary'
        };
      }
    },
    cancelButtonProps: {
      type: Object,
      "default": function _default() {
        return {
          severity: 'secondary'
        };
      }
    }
  },
  style: FileUploadStyle,
  provide: function provide() {
    return {
      $pcFileUpload: this,
      $parentInstance: this
    };
  }
};

var script$1 = {
  name: 'FileContent',
  hostName: 'FileUpload',
  "extends": BaseComponent,
  emits: ['remove'],
  props: {
    files: {
      type: Array,
      "default": function _default() {
        return [];
      }
    },
    badgeSeverity: {
      type: String,
      "default": 'warn'
    },
    badgeValue: {
      type: String,
      "default": null
    },
    previewWidth: {
      type: Number,
      "default": 50
    },
    templates: {
      type: null,
      "default": null
    }
  },
  methods: {
    formatSize: function formatSize(bytes) {
      var _this$$primevue$confi;
      var k = 1024;
      var dm = 3;
      var sizes = ((_this$$primevue$confi = this.$primevue.config.locale) === null || _this$$primevue$confi === void 0 ? void 0 : _this$$primevue$confi.fileSizeTypes) || ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
      if (bytes === 0) {
        return "0 ".concat(sizes[0]);
      }
      var i = Math.floor(Math.log(bytes) / Math.log(k));
      var formattedSize = parseFloat((bytes / Math.pow(k, i)).toFixed(dm));
      return "".concat(formattedSize, " ").concat(sizes[i]);
    }
  },
  components: {
    Button: Button,
    Badge: Badge,
    TimesIcon: TimesIcon
  }
};

var _hoisted_1$1 = ["alt", "src", "width"];
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_Badge = resolveComponent("Badge");
  var _component_TimesIcon = resolveComponent("TimesIcon");
  var _component_Button = resolveComponent("Button");
  return openBlock(true), createElementBlock(Fragment, null, renderList($props.files, function (file, index) {
    return openBlock(), createElementBlock("div", mergeProps({
      key: file.name + file.type + file.size,
      "class": _ctx.cx('file')
    }, {
      ref_for: true
    }, _ctx.ptm('file')), [createElementVNode("img", mergeProps({
      role: "presentation",
      "class": _ctx.cx('fileThumbnail'),
      alt: file.name,
      src: file.objectURL,
      width: $props.previewWidth
    }, {
      ref_for: true
    }, _ctx.ptm('fileThumbnail')), null, 16, _hoisted_1$1), createElementVNode("div", mergeProps({
      "class": _ctx.cx('fileInfo')
    }, {
      ref_for: true
    }, _ctx.ptm('fileInfo')), [createElementVNode("div", mergeProps({
      "class": _ctx.cx('fileName')
    }, {
      ref_for: true
    }, _ctx.ptm('fileName')), toDisplayString(file.name), 17), createElementVNode("span", mergeProps({
      "class": _ctx.cx('fileSize')
    }, {
      ref_for: true
    }, _ctx.ptm('fileSize')), toDisplayString($options.formatSize(file.size)), 17)], 16), createVNode(_component_Badge, {
      value: $props.badgeValue,
      "class": normalizeClass(_ctx.cx('pcFileBadge')),
      severity: $props.badgeSeverity,
      unstyled: _ctx.unstyled,
      pt: _ctx.ptm('pcFileBadge')
    }, null, 8, ["value", "class", "severity", "unstyled", "pt"]), createElementVNode("div", mergeProps({
      "class": _ctx.cx('fileActions')
    }, {
      ref_for: true
    }, _ctx.ptm('fileActions')), [createVNode(_component_Button, {
      onClick: function onClick($event) {
        return _ctx.$emit('remove', index);
      },
      text: "",
      rounded: "",
      severity: "danger",
      "class": normalizeClass(_ctx.cx('pcFileRemoveButton')),
      unstyled: _ctx.unstyled,
      pt: _ctx.ptm('pcFileRemoveButton')
    }, {
      icon: withCtx(function (iconProps) {
        return [$props.templates.fileremoveicon ? (openBlock(), createBlock(resolveDynamicComponent($props.templates.fileremoveicon), {
          key: 0,
          "class": normalizeClass(iconProps["class"]),
          file: file,
          index: index
        }, null, 8, ["class", "file", "index"])) : (openBlock(), createBlock(_component_TimesIcon, mergeProps({
          key: 1,
          "class": iconProps["class"],
          "aria-hidden": "true"
        }, {
          ref_for: true
        }, _ctx.ptm('pcFileRemoveButton')['icon']), null, 16, ["class"]))];
      }),
      _: 2
    }, 1032, ["onClick", "class", "unstyled", "pt"])], 16)], 16);
  }), 128);
}

script$1.render = render$1;

function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: true } : { done: false, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = true, u = false; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = true, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
var script = {
  name: 'FileUpload',
  "extends": script$2,
  inheritAttrs: false,
  emits: ['select', 'uploader', 'before-upload', 'progress', 'upload', 'error', 'before-send', 'clear', 'remove', 'remove-uploaded-file'],
  duplicateIEEvent: false,
  data: function data() {
    return {
      uploadedFileCount: 0,
      files: [],
      messages: [],
      focused: false,
      progress: null,
      uploadedFiles: []
    };
  },
  methods: {
    upload: function upload() {
      if (this.hasFiles) this.uploader();
    },
    onBasicUploaderClick: function onBasicUploaderClick(event) {
      if (event.button === 0) this.$refs.fileInput.click();
    },
    onFileSelect: function onFileSelect(event) {
      if (event.type !== 'drop' && this.isIE11() && this.duplicateIEEvent) {
        this.duplicateIEEvent = false;
        return;
      }
      if (this.isBasic && this.hasFiles) {
        this.files = [];
      }
      this.messages = [];
      this.files = this.files || [];
      var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;
      var _iterator = _createForOfIteratorHelper(files),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var file = _step.value;
          if (!this.isFileSelected(file) && !this.isFileLimitExceeded()) {
            if (this.validate(file)) {
              if (this.isImage(file)) {
                file.objectURL = window.URL.createObjectURL(file);
              }
              this.files.push(file);
            }
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      this.$emit('select', {
        originalEvent: event,
        files: this.files
      });
      if (this.fileLimit) {
        this.checkFileLimit();
      }
      if (this.auto && this.hasFiles && !this.isFileLimitExceeded()) {
        this.uploader();
      }
      if (event.type !== 'drop' && this.isIE11()) {
        this.clearIEInput();
      } else {
        this.clearInputElement();
      }
    },
    choose: function choose() {
      this.$refs.fileInput.click();
    },
    uploader: function uploader() {
      var _this = this;
      if (this.customUpload) {
        if (this.fileLimit) {
          this.uploadedFileCount += this.files.length;
        }
        this.$emit('uploader', {
          files: this.files
        });
      } else {
        var xhr = new XMLHttpRequest();
        var formData = new FormData();
        this.$emit('before-upload', {
          xhr: xhr,
          formData: formData
        });
        var _iterator2 = _createForOfIteratorHelper(this.files),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var file = _step2.value;
            formData.append(this.name, file, file.name);
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
        xhr.upload.addEventListener('progress', function (event) {
          if (event.lengthComputable) {
            _this.progress = Math.round(event.loaded * 100 / event.total);
          }
          _this.$emit('progress', {
            originalEvent: event,
            progress: _this.progress
          });
        });
        xhr.onreadystatechange = function () {
          if (xhr.readyState === 4) {
            _this.progress = 0;
            if (xhr.status >= 200 && xhr.status < 300) {
              var _this$uploadedFiles;
              if (_this.fileLimit) {
                _this.uploadedFileCount += _this.files.length;
              }
              _this.$emit('upload', {
                xhr: xhr,
                files: _this.files
              });
              (_this$uploadedFiles = _this.uploadedFiles).push.apply(_this$uploadedFiles, _toConsumableArray(_this.files));
            } else {
              _this.$emit('error', {
                xhr: xhr,
                files: _this.files
              });
            }
            _this.clear();
          }
        };
        if (this.url) {
          xhr.open('POST', this.url, true);
          this.$emit('before-send', {
            xhr: xhr,
            formData: formData
          });
          xhr.withCredentials = this.withCredentials;
          xhr.send(formData);
        }
      }
    },
    clear: function clear() {
      this.files = [];
      this.messages = null;
      this.$emit('clear');
      if (this.isAdvanced) {
        this.clearInputElement();
      }
    },
    onFocus: function onFocus() {
      this.focused = true;
    },
    onBlur: function onBlur() {
      this.focused = false;
    },
    isFileSelected: function isFileSelected(file) {
      if (this.files && this.files.length) {
        var _iterator3 = _createForOfIteratorHelper(this.files),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var sFile = _step3.value;
            if (sFile.name + sFile.type + sFile.size === file.name + file.type + file.size) return true;
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }
      return false;
    },
    isIE11: function isIE11() {
      return !!window['MSInputMethodContext'] && !!document['documentMode'];
    },
    validate: function validate(file) {
      if (this.accept && !this.isFileTypeValid(file)) {
        this.messages.push(this.invalidFileTypeMessage.replace('{0}', file.name).replace('{1}', this.accept));
        return false;
      }
      if (this.maxFileSize && file.size > this.maxFileSize) {
        this.messages.push(this.invalidFileSizeMessage.replace('{0}', file.name).replace('{1}', this.formatSize(this.maxFileSize)));
        return false;
      }
      return true;
    },
    isFileTypeValid: function isFileTypeValid(file) {
      var acceptableTypes = this.accept.split(',').map(function (type) {
        return type.trim();
      });
      var _iterator4 = _createForOfIteratorHelper(acceptableTypes),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var type = _step4.value;
          var acceptable = this.isWildcard(type) ? this.getTypeClass(file.type) === this.getTypeClass(type) : file.type == type || this.getFileExtension(file).toLowerCase() === type.toLowerCase();
          if (acceptable) {
            return true;
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return false;
    },
    getTypeClass: function getTypeClass(fileType) {
      return fileType.substring(0, fileType.indexOf('/'));
    },
    isWildcard: function isWildcard(fileType) {
      return fileType.indexOf('*') !== -1;
    },
    getFileExtension: function getFileExtension(file) {
      return '.' + file.name.split('.').pop();
    },
    isImage: function isImage(file) {
      return /^image\//.test(file.type);
    },
    onDragEnter: function onDragEnter(event) {
      if (!this.disabled) {
        event.stopPropagation();
        event.preventDefault();
      }
    },
    onDragOver: function onDragOver(event) {
      if (!this.disabled) {
        !this.isUnstyled && addClass(this.$refs.content, 'p-fileupload-highlight');
        this.$refs.content.setAttribute('data-p-highlight', true);
        event.stopPropagation();
        event.preventDefault();
      }
    },
    onDragLeave: function onDragLeave() {
      if (!this.disabled) {
        !this.isUnstyled && removeClass(this.$refs.content, 'p-fileupload-highlight');
        this.$refs.content.setAttribute('data-p-highlight', false);
      }
    },
    onDrop: function onDrop(event) {
      if (!this.disabled) {
        !this.isUnstyled && removeClass(this.$refs.content, 'p-fileupload-highlight');
        this.$refs.content.setAttribute('data-p-highlight', false);
        event.stopPropagation();
        event.preventDefault();
        var files = event.dataTransfer ? event.dataTransfer.files : event.target.files;
        var allowDrop = this.multiple || files && files.length === 1;
        if (allowDrop) {
          this.onFileSelect(event);
        }
      }
    },
    remove: function remove(index) {
      this.clearInputElement();
      var removedFile = this.files.splice(index, 1)[0];
      this.files = _toConsumableArray(this.files);
      this.$emit('remove', {
        file: removedFile,
        files: this.files
      });
    },
    removeUploadedFile: function removeUploadedFile(index) {
      var removedFile = this.uploadedFiles.splice(index, 1)[0];
      this.uploadedFiles = _toConsumableArray(this.uploadedFiles);
      this.$emit('remove-uploaded-file', {
        file: removedFile,
        files: this.uploadedFiles
      });
    },
    clearInputElement: function clearInputElement() {
      this.$refs.fileInput.value = '';
    },
    clearIEInput: function clearIEInput() {
      if (this.$refs.fileInput) {
        this.duplicateIEEvent = true; //IE11 fix to prevent onFileChange trigger again
        this.$refs.fileInput.value = '';
      }
    },
    formatSize: function formatSize(bytes) {
      var _this$$primevue$confi;
      var k = 1024;
      var dm = 3;
      var sizes = ((_this$$primevue$confi = this.$primevue.config.locale) === null || _this$$primevue$confi === void 0 ? void 0 : _this$$primevue$confi.fileSizeTypes) || ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
      if (bytes === 0) {
        return "0 ".concat(sizes[0]);
      }
      var i = Math.floor(Math.log(bytes) / Math.log(k));
      var formattedSize = parseFloat((bytes / Math.pow(k, i)).toFixed(dm));
      return "".concat(formattedSize, " ").concat(sizes[i]);
    },
    isFileLimitExceeded: function isFileLimitExceeded() {
      if (this.fileLimit && this.fileLimit <= this.files.length + this.uploadedFileCount && this.focused) {
        this.focused = false;
      }
      return this.fileLimit && this.fileLimit < this.files.length + this.uploadedFileCount;
    },
    checkFileLimit: function checkFileLimit() {
      if (this.isFileLimitExceeded()) {
        this.messages.push(this.invalidFileLimitMessage.replace('{0}', this.fileLimit.toString()));
      }
    },
    onMessageClose: function onMessageClose() {
      this.messages = null;
    }
  },
  computed: {
    isAdvanced: function isAdvanced() {
      return this.mode === 'advanced';
    },
    isBasic: function isBasic() {
      return this.mode === 'basic';
    },
    chooseButtonClass: function chooseButtonClass() {
      return [this.cx('pcChooseButton'), this["class"]];
    },
    basicFileChosenLabel: function basicFileChosenLabel() {
      var _this$$primevue$confi3;
      if (this.auto) return this.chooseButtonLabel;else if (this.hasFiles) {
        var _this$$primevue$confi2;
        if (this.files && this.files.length === 1) return this.files[0].name;
        return (_this$$primevue$confi2 = this.$primevue.config.locale) === null || _this$$primevue$confi2 === void 0 || (_this$$primevue$confi2 = _this$$primevue$confi2.fileChosenMessage) === null || _this$$primevue$confi2 === void 0 ? void 0 : _this$$primevue$confi2.replace('{0}', this.files.length);
      }
      return ((_this$$primevue$confi3 = this.$primevue.config.locale) === null || _this$$primevue$confi3 === void 0 ? void 0 : _this$$primevue$confi3.noFileChosenMessage) || '';
    },
    hasFiles: function hasFiles() {
      return this.files && this.files.length > 0;
    },
    hasUploadedFiles: function hasUploadedFiles() {
      return this.uploadedFiles && this.uploadedFiles.length > 0;
    },
    chooseDisabled: function chooseDisabled() {
      return this.disabled || this.fileLimit && this.fileLimit <= this.files.length + this.uploadedFileCount;
    },
    uploadDisabled: function uploadDisabled() {
      return this.disabled || !this.hasFiles || this.fileLimit && this.fileLimit < this.files.length;
    },
    cancelDisabled: function cancelDisabled() {
      return this.disabled || !this.hasFiles;
    },
    chooseButtonLabel: function chooseButtonLabel() {
      return this.chooseLabel || this.$primevue.config.locale.choose;
    },
    uploadButtonLabel: function uploadButtonLabel() {
      return this.uploadLabel || this.$primevue.config.locale.upload;
    },
    cancelButtonLabel: function cancelButtonLabel() {
      return this.cancelLabel || this.$primevue.config.locale.cancel;
    },
    completedLabel: function completedLabel() {
      return this.$primevue.config.locale.completed;
    },
    pendingLabel: function pendingLabel() {
      return this.$primevue.config.locale.pending;
    }
  },
  components: {
    Button: Button,
    ProgressBar: ProgressBar,
    Message: Message,
    FileContent: script$1,
    PlusIcon: PlusIcon,
    UploadIcon: UploadIcon,
    TimesIcon: TimesIcon
  },
  directives: {
    ripple: Ripple
  }
};

var _hoisted_1 = ["multiple", "accept", "disabled"];
var _hoisted_2 = ["accept", "disabled", "multiple"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_Button = resolveComponent("Button");
  var _component_ProgressBar = resolveComponent("ProgressBar");
  var _component_Message = resolveComponent("Message");
  var _component_FileContent = resolveComponent("FileContent");
  return $options.isAdvanced ? (openBlock(), createElementBlock("div", mergeProps({
    key: 0,
    "class": _ctx.cx('root')
  }, _ctx.ptmi('root')), [createElementVNode("input", mergeProps({
    ref: "fileInput",
    type: "file",
    onChange: _cache[0] || (_cache[0] = function () {
      return $options.onFileSelect && $options.onFileSelect.apply($options, arguments);
    }),
    multiple: _ctx.multiple,
    accept: _ctx.accept,
    disabled: $options.chooseDisabled
  }, _ctx.ptm('input')), null, 16, _hoisted_1), createElementVNode("div", mergeProps({
    "class": _ctx.cx('header')
  }, _ctx.ptm('header')), [renderSlot(_ctx.$slots, "header", {
    files: $data.files,
    uploadedFiles: $data.uploadedFiles,
    chooseCallback: $options.choose,
    uploadCallback: $options.uploader,
    clearCallback: $options.clear
  }, function () {
    return [createVNode(_component_Button, mergeProps({
      label: $options.chooseButtonLabel,
      "class": $options.chooseButtonClass,
      style: _ctx.style,
      disabled: _ctx.disabled,
      unstyled: _ctx.unstyled,
      onClick: $options.choose,
      onKeydown: withKeys($options.choose, ["enter"]),
      onFocus: $options.onFocus,
      onBlur: $options.onBlur
    }, _ctx.chooseButtonProps, {
      pt: _ctx.ptm('pcChooseButton')
    }), {
      icon: withCtx(function (iconProps) {
        return [renderSlot(_ctx.$slots, "chooseicon", {}, function () {
          return [(openBlock(), createBlock(resolveDynamicComponent(_ctx.chooseIcon ? 'span' : 'PlusIcon'), mergeProps({
            "class": [iconProps["class"], _ctx.chooseIcon],
            "aria-hidden": "true"
          }, _ctx.ptm('pcChooseButton')['icon']), null, 16, ["class"]))];
        })];
      }),
      _: 3
    }, 16, ["label", "class", "style", "disabled", "unstyled", "onClick", "onKeydown", "onFocus", "onBlur", "pt"]), _ctx.showUploadButton ? (openBlock(), createBlock(_component_Button, mergeProps({
      key: 0,
      "class": _ctx.cx('pcUploadButton'),
      label: $options.uploadButtonLabel,
      onClick: $options.uploader,
      disabled: $options.uploadDisabled,
      unstyled: _ctx.unstyled
    }, _ctx.uploadButtonProps, {
      pt: _ctx.ptm('pcUploadButton')
    }), {
      icon: withCtx(function (iconProps) {
        return [renderSlot(_ctx.$slots, "uploadicon", {}, function () {
          return [(openBlock(), createBlock(resolveDynamicComponent(_ctx.uploadIcon ? 'span' : 'UploadIcon'), mergeProps({
            "class": [iconProps["class"], _ctx.uploadIcon],
            "aria-hidden": "true"
          }, _ctx.ptm('pcUploadButton')['icon'], {
            "data-pc-section": "uploadbuttonicon"
          }), null, 16, ["class"]))];
        })];
      }),
      _: 3
    }, 16, ["class", "label", "onClick", "disabled", "unstyled", "pt"])) : createCommentVNode("", true), _ctx.showCancelButton ? (openBlock(), createBlock(_component_Button, mergeProps({
      key: 1,
      "class": _ctx.cx('pcCancelButton'),
      label: $options.cancelButtonLabel,
      onClick: $options.clear,
      disabled: $options.cancelDisabled,
      unstyled: _ctx.unstyled
    }, _ctx.cancelButtonProps, {
      pt: _ctx.ptm('pcCancelButton')
    }), {
      icon: withCtx(function (iconProps) {
        return [renderSlot(_ctx.$slots, "cancelicon", {}, function () {
          return [(openBlock(), createBlock(resolveDynamicComponent(_ctx.cancelIcon ? 'span' : 'TimesIcon'), mergeProps({
            "class": [iconProps["class"], _ctx.cancelIcon],
            "aria-hidden": "true"
          }, _ctx.ptm('pcCancelButton')['icon'], {
            "data-pc-section": "cancelbuttonicon"
          }), null, 16, ["class"]))];
        })];
      }),
      _: 3
    }, 16, ["class", "label", "onClick", "disabled", "unstyled", "pt"])) : createCommentVNode("", true)];
  })], 16), createElementVNode("div", mergeProps({
    ref: "content",
    "class": _ctx.cx('content'),
    onDragenter: _cache[1] || (_cache[1] = function () {
      return $options.onDragEnter && $options.onDragEnter.apply($options, arguments);
    }),
    onDragover: _cache[2] || (_cache[2] = function () {
      return $options.onDragOver && $options.onDragOver.apply($options, arguments);
    }),
    onDragleave: _cache[3] || (_cache[3] = function () {
      return $options.onDragLeave && $options.onDragLeave.apply($options, arguments);
    }),
    onDrop: _cache[4] || (_cache[4] = function () {
      return $options.onDrop && $options.onDrop.apply($options, arguments);
    })
  }, _ctx.ptm('content'), {
    "data-p-highlight": false
  }), [renderSlot(_ctx.$slots, "content", {
    files: $data.files,
    uploadedFiles: $data.uploadedFiles,
    removeUploadedFileCallback: $options.removeUploadedFile,
    removeFileCallback: $options.remove,
    progress: $data.progress,
    messages: $data.messages
  }, function () {
    return [$options.hasFiles ? (openBlock(), createBlock(_component_ProgressBar, {
      key: 0,
      value: $data.progress,
      showValue: false,
      unstyled: _ctx.unstyled,
      pt: _ctx.ptm('pcProgressbar')
    }, null, 8, ["value", "unstyled", "pt"])) : createCommentVNode("", true), (openBlock(true), createElementBlock(Fragment, null, renderList($data.messages, function (msg) {
      return openBlock(), createBlock(_component_Message, {
        key: msg,
        severity: "error",
        onClose: $options.onMessageClose,
        unstyled: _ctx.unstyled,
        pt: _ctx.ptm('pcMessage')
      }, {
        "default": withCtx(function () {
          return [createTextVNode(toDisplayString(msg), 1)];
        }),
        _: 2
      }, 1032, ["onClose", "unstyled", "pt"]);
    }), 128)), $options.hasFiles ? (openBlock(), createElementBlock("div", {
      key: 1,
      "class": normalizeClass(_ctx.cx('fileList'))
    }, [createVNode(_component_FileContent, {
      files: $data.files,
      onRemove: $options.remove,
      badgeValue: $options.pendingLabel,
      previewWidth: _ctx.previewWidth,
      templates: _ctx.$slots,
      unstyled: _ctx.unstyled,
      pt: _ctx.pt
    }, null, 8, ["files", "onRemove", "badgeValue", "previewWidth", "templates", "unstyled", "pt"])], 2)) : createCommentVNode("", true), $options.hasUploadedFiles ? (openBlock(), createElementBlock("div", {
      key: 2,
      "class": normalizeClass(_ctx.cx('fileList'))
    }, [createVNode(_component_FileContent, {
      files: $data.uploadedFiles,
      onRemove: $options.removeUploadedFile,
      badgeValue: $options.completedLabel,
      badgeSeverity: "success",
      previewWidth: _ctx.previewWidth,
      templates: _ctx.$slots,
      unstyled: _ctx.unstyled,
      pt: _ctx.pt
    }, null, 8, ["files", "onRemove", "badgeValue", "previewWidth", "templates", "unstyled", "pt"])], 2)) : createCommentVNode("", true)];
  }), _ctx.$slots.empty && !$options.hasFiles && !$options.hasUploadedFiles ? (openBlock(), createElementBlock("div", normalizeProps(mergeProps({
    key: 0
  }, _ctx.ptm('empty'))), [renderSlot(_ctx.$slots, "empty")], 16)) : createCommentVNode("", true)], 16)], 16)) : $options.isBasic ? (openBlock(), createElementBlock("div", mergeProps({
    key: 1,
    "class": _ctx.cx('root')
  }, _ctx.ptmi('root')), [(openBlock(true), createElementBlock(Fragment, null, renderList($data.messages, function (msg) {
    return openBlock(), createBlock(_component_Message, {
      key: msg,
      severity: "error",
      onClose: $options.onMessageClose,
      unstyled: _ctx.unstyled,
      pt: _ctx.ptm('pcMessage')
    }, {
      "default": withCtx(function () {
        return [createTextVNode(toDisplayString(msg), 1)];
      }),
      _: 2
    }, 1032, ["onClose", "unstyled", "pt"]);
  }), 128)), createElementVNode("div", mergeProps({
    "class": _ctx.cx('basicContent')
  }, _ctx.ptm('basicContent')), [createVNode(_component_Button, mergeProps({
    label: $options.chooseButtonLabel,
    "class": $options.chooseButtonClass,
    style: _ctx.style,
    disabled: _ctx.disabled,
    unstyled: _ctx.unstyled,
    onMouseup: $options.onBasicUploaderClick,
    onKeydown: withKeys($options.choose, ["enter"]),
    onFocus: $options.onFocus,
    onBlur: $options.onBlur
  }, _ctx.chooseButtonProps, {
    pt: _ctx.ptm('pcChooseButton')
  }), {
    icon: withCtx(function (iconProps) {
      return [renderSlot(_ctx.$slots, "chooseicon", {}, function () {
        return [(openBlock(), createBlock(resolveDynamicComponent(_ctx.chooseIcon ? 'span' : 'PlusIcon'), mergeProps({
          "class": [iconProps["class"], _ctx.chooseIcon],
          "aria-hidden": "true"
        }, _ctx.ptm('pcChooseButton')['icon']), null, 16, ["class"]))];
      })];
    }),
    _: 3
  }, 16, ["label", "class", "style", "disabled", "unstyled", "onMouseup", "onKeydown", "onFocus", "onBlur", "pt"]), !_ctx.auto ? renderSlot(_ctx.$slots, "filelabel", {
    key: 0,
    "class": normalizeClass(_ctx.cx('filelabel')),
    files: $data.files
  }, function () {
    return [createElementVNode("span", {
      "class": normalizeClass(_ctx.cx('filelabel'))
    }, toDisplayString($options.basicFileChosenLabel), 3)];
  }) : createCommentVNode("", true), createElementVNode("input", mergeProps({
    ref: "fileInput",
    type: "file",
    accept: _ctx.accept,
    disabled: _ctx.disabled,
    multiple: _ctx.multiple,
    onChange: _cache[5] || (_cache[5] = function () {
      return $options.onFileSelect && $options.onFileSelect.apply($options, arguments);
    }),
    onFocus: _cache[6] || (_cache[6] = function () {
      return $options.onFocus && $options.onFocus.apply($options, arguments);
    }),
    onBlur: _cache[7] || (_cache[7] = function () {
      return $options.onBlur && $options.onBlur.apply($options, arguments);
    })
  }, _ctx.ptm('input')), null, 16, _hoisted_2)], 16)], 16)) : createCommentVNode("", true);
}

script.render = render;

export { script as default };
//# sourceMappingURL=index.mjs.map
