/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

import './bootstrap';
import '../css/app.css';
import 'primeicons/primeicons.css'

import { createApp } from 'vue';

/**
 * Next, we will create a fresh Vue application instance. You may then begin
 * registering components with the application instance so they are ready
 * to use in your application's views. An example is included for you.
 */

import App from './pages/App.vue';
const app = createApp(App);

import router from './router.js';
app.use(router);

import PrimeVue from 'primevue/config';
import Ripple from 'primevue/ripple'
import Aura from '@primeuix/themes/aura';
import { definePreset } from '@primeuix/themes';

const Noir = definePreset(Aura, {
  semantic: {
    primary: {
      50: '{zinc.50}',
      100: '{zinc.100}',
      200: '{zinc.200}',
      300: '{zinc.300}',
      400: '{zinc.400}',
      500: '{zinc.500}',
      600: '{zinc.600}',
      700: '{zinc.700}',
      800: '{zinc.800}',
      900: '{zinc.900}',
      950: '{zinc.950}'
    },
    // colorScheme: {
    //   light: {
    //     primary: {
    //       color: '{zinc.950}',
    //       inverseColor: '#ffffff',
    //       hoverColor: '{zinc.900}',
    //       activeColor: '{zinc.800}'
    //     },
    //     highlight: {
    //       background: '{zinc.950}',
    //       focusBackground: '{zinc.700}',
    //       color: '#ffffff',
    //       focusColor: '#ffffff'
    //     }
    //   },
    //   dark: {
    //     primary: {
    //       color: '{zinc.50}',
    //       inverseColor: '{zinc.950}',
    //       hoverColor: '{zinc.100}',
    //       activeColor: '{zinc.200}'
    //     },
    //     highlight: {
    //       background: 'rgba(250, 250, 250, .16)',
    //       focusBackground: 'rgba(250, 250, 250, .24)',
    //       color: 'rgba(255,255,255,.87)',
    //       focusColor: 'rgba(255,255,255,.87)'
    //     }
    //   }
    // }
  }
});

app.use(PrimeVue, {
  theme: {
    preset: Noir,
    options: {
      // darkModeSelector: false || 'none',
      darkModeSelector: '.dark',
      cssLayer: { // tailwindCSS 及 primeVue 載入順序設定
        name: 'primevue',
        order: 'tailwind-base, primevue, tailwind-utilities'
      }
    }
  }
});
app.directive('ripple', Ripple)

/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// Object.entries(import.meta.glob('./**/*.vue', { eager: true })).forEach(([path, definition]) => {
//     app.component(path.split('/').pop().replace(/\.\w+$/, ''), definition.default);
// });

/**
 * Finally, we will attach the application instance to a HTML element with
 * an "id" attribute of "app". This element is included with the "auth"
 * scaffolding. Otherwise, you will need to add an element yourself.
 */

app.mount('#app');
