import axios from "axios";

const ASSET_URL = import.meta.env.VITE_ASSET_URL

const api = axios.create({
    baseURL: ASSET_URL,
    headers: {
        accept: "application/json",
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        Authorization: 'Bearer ' + $('meta[name="api_token"]').attr("content"),
    },
    contentType: false,
    processData: false,
});

export { api };