// utils/swal.js
import Swal from 'sweetalert2'

const baseOptions = {
  customClass: {
    popup: 'rounded-xl shadow-xl p-6', // 外框
    title: 'text-xl font-bold text-gray-800',
    confirmButton: 'bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded focus:outline-none',
    cancelButton: 'bg-gray-300 hover:bg-gray-400 text-gray-800 px-4 py-2 rounded focus:outline-none',
    denyButton: 'bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded',
  },
  buttonsStyling: false, // 禁用原生按鈕樣式，讓 Tailwind 生效
}

export const useSwal = {
  success(message = '操作成功', title = '成功') {
    return Swal.fire({
      icon: 'success',
      title,
      text: message,
      ...baseOptions,
    })
  },
  error(message = '操作失敗', title = '錯誤') {
    return Swal.fire({
      icon: 'error',
      title,
      text: message,
      ...baseOptions,
    })
  },
  confirm({ title = '確認操作？', text = '', confirmText = '確定', cancelText = '取消' }) {
    return Swal.fire({
      icon: 'question',
      title,
      text,
      showCancelButton: true,
      confirmButtonText: confirmText,
      cancelButtonText: cancelText,
      ...baseOptions,
    })
  },
}
