// // useDarkMode.js
// import { ref, watchEffect } from 'vue'

// const isDark = ref(
//   localStorage.getItem('theme') === 'dark' ||
//   (!localStorage.getItem('theme') &&
//     window.matchMedia('(prefers-color-scheme: dark)').matches)
// )

// // ⏱ 立即同步 class（防白屏）
// document.documentElement.classList.toggle('dark', isDark.value)

// export function useDarkMode() {
//   watchEffect(() => {
//     if (isDark.value) {
//       document.documentElement.classList.add('dark')
//       localStorage.setItem('theme', 'dark')
//     } else {
//       document.documentElement.classList.remove('dark')
//       localStorage.setItem('theme', 'light')
//     }
//   })

//   function toggleDark() {
//     isDark.value = !isDark.value
//   }

//   return {
//     isDark,
//     toggleDark,
//   }
// }

// useDarkMode.js
import { ref, watchEffect } from 'vue'

// 強制為 light 模式
const isDark = ref(false)

// 立即同步 class（防白屏）
document.documentElement.classList.remove('dark')
localStorage.setItem('theme', 'light')

export function useDarkMode() {
  watchEffect(() => {
    document.documentElement.classList.remove('dark')
    localStorage.setItem('theme', 'light')
  })

  function toggleDark() {
    // 不做任何事，或強制保持 light
    isDark.value = false
  }

  return {
    isDark,
    toggleDark,
  }
}