import { createRouter, createWebHistory, useRouter } from "vue-router";

const ASSET_URL = import.meta.env.VITE_ASSET_URL

const routes = [
  {
    name: "Maintain",
    path: "/Maintain",
    component: () => import("./pages/Maintain.vue"),
    meta: {}
  },
  {
    name: "Home",
    path: "/",
    component: () => import("./pages/Home/Index.vue"),
    meta: {}
  },
  {
    name: "FactoryIndex",
    path: "/Factory/Index",
    component: () => import("./pages/Factory/Index.vue"),
    meta: {},
  },
  {
    name: "EquipmentIndex",
    path: "/Equipment/Index",
    component: () => import("./pages/Equipment/Index.vue"),
    meta: {}
  },
  {
    name: "EquipmentRecord",
    path: "/Equipment/Record",
    component: () => import("./pages/Equipment/Record.vue"),
    meta: {}
  },
  {
    name: "EquipmentBank",
    path: "/EquipmentBank/:id",
    component: () => import("./pages/EquipmentBank/Index.vue"),
    meta: {},
  },
  {
    name: "EquipmentCategoryIndex",
    path: "/EquipmentCategories/Index",
    component: () => import("./pages/EquipmentCategories/Index.vue"),
    meta: {}
  },
  {
    name: "BankIndex",
    path: "/BankList/Index",
    component: () => import("./pages/BankList/Index.vue"),
    meta: {}
  },
  {
    name: "BankDetailIndex",
    path: "/BankDetail/:id/:eq_cat_id",
    component: () => import("./pages/BankDetail/Index.vue"),
    meta: {},
  },
  {
    name: "BankImport",
    path: "/BankList/ImportBank",
    component: () => import("./pages/BankList/ImportBank.vue"),
    meta: {},
  },
  {
    name: "BankManual",
    path: "/BankList/Manual",
    component: () => import("./pages/BankList/Manual.vue"),
    meta: {},
  },
  {
    name: "DispatchIndex",
    path: "/Dispatch/Index",
    component: () => import("./pages/Dispatch/Index.vue"),
    meta: {},
  },
  {
    name: "DispatchCreate",
    path: "/Dispatch/Create",
    component: () => import("./pages/Dispatch/Create.vue"),
    meta: {},
  },
  {
    name: "DispatchEdit",
    path: "/Dispatch/:id/Edit",
    component: () => import("./pages/Dispatch/Edit.vue"),
    meta: {},
  },
  {
    name: "CheckListIndex",
    path: "/CheckList/Index",
    component: () => import("./pages/CheckList/Index.vue"),
    meta: {},
  },
  {
    name: "CheckDetail",
    path: "/CheckDetail/:id/Index",
    component: () => import("./pages/CheckDetail/Index.vue"),
    meta: {},
  },
  {
    name: "DailyIndex",
    path: "/Daily/Index",
    component: () => import("./pages/Daily/Index.vue"),
    meta: {},
  },
  {
    name: "DailyCreate",
    path: "/Daily/Create",
    component: () => import("./pages/Daily/Create.vue"),
    meta: {},
  },
  {
    name: "Analysis",
    path: "/Analysis",
    component: () => import("./pages/Analysis/Index.vue"),
    meta: {},
  }
  

  // {
  //   path: '/:pathMatch(.*)*',
  //   name: 'NotFound',
  //   component: () => import('./pages/NotFound.vue'),
  //   meta: { layout: false }
  // }
];

const router = createRouter({
  history: createWebHistory(ASSET_URL), // 這裡設定 base path
  routes
});

// router.beforeEach((to, from, next) => {
//   if (to.matched.length === 0) {
//     // 導回上一個合法頁
//     router.back()
//   } else {
//     next()
//   }
// })

export default router