<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\FactoryController;
use App\Http\Controllers\Api\EquipmentController;
use App\Http\Controllers\Api\EquipmentCategoryController;
use App\Http\Controllers\Api\EquipmentRecordController;
use App\Http\Controllers\Api\EquipmentBankController;
use App\Http\Controllers\Api\BankRiskController;
use App\Http\Controllers\Api\BankListController;
use App\Http\Controllers\Api\BankDetailController;
use App\Http\Controllers\Api\DispatchSetController;
use App\Http\Controllers\Api\CheckListController;
use App\Http\Controllers\Api\CheckBankDetailController;
use App\Http\Controllers\Api\CheckPhotoController;
use App\Http\Controllers\Api\DailyController;
use App\Http\Controllers\Api\DailyPhotoController;

// App
use App\Http\Controllers\Api\App\AuthController;
use App\Http\Controllers\Api\App\DownloadController;
use App\Http\Controllers\Api\App\UploadController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::post('login', [AuthController::class ,'login']);

Route::middleware('auth:api')->group(function () {
    Route::get('/getuser', [UserController::class, 'getUser']);

    Route::apiResource('factory', FactoryController::class);
    Route::apiResource('equipments', EquipmentController::class);
    Route::apiResource('equipment-categories', EquipmentCategoryController::class);
    Route::apiResource('equipment-record', EquipmentRecordController::class);
    Route::apiResource('equipment-bank', EquipmentBankController::class);
    Route::apiResource('risk-levels', BankRiskController::class);
    Route::apiResource('bank-list', BankListController::class);
    Route::apiResource('bank-detail', BankDetailController::class);
    Route::apiResource('dispatch', DispatchSetController::class);
    Route::apiResource('check-list', CheckListController::class);
    Route::apiResource('check-bank-detail', CheckBankDetailController::class);
    Route::apiResource('check-photo', CheckPhotoController::class);
    Route::apiResource('daily', DailyController::class);
    Route::apiResource('daily-photo', DailyPhotoController::class);

    Route::post('/equipment/import', [EquipmentController::class, 'importEquipment']);
    Route::post('/equipment/export', [EquipmentController::class, 'ExportEquipment']);

    // 設備管理 - 設備類別 - 檢查項目 - 更新/創建資料
    Route::post('/equipmentBank/updateOrCrate', [EquipmentBankController::class , 'updateOrCrate']);

    // 設備管理 - 設備類別 - 檢查項目 - 匯入/出表單
    Route::post('/equipmentBank/import', [EquipmentBankController::class , 'importEquipmentBank']);
    Route::post('/equipmentBank/export', [EquipmentBankController::class , 'exportEquipmentBank']);

    // 檢核表單 - 1. 快速生成 2. 表單匯入 3. 手動新增
    Route::get('/eqipment/getEquipment', [BankListController::class , 'getEquipment']);
    Route::post('/bankList/import' , [BankListController::class , 'importBank']);
    Route::post('/bankList/manual', [BankListController::class , 'manualBank']);

    // 檢核表單 - 檢查項目 - 匯出表單
    Route::post('/bankDetail/export', [BankDetailController::class , 'exportBankDetail']);
    // 檢核表單 - 檢查項目 - 更新/創建資料
    Route::post('/bankDetail/updateOrCrate', [BankDetailController::class , 'updateOrCrate']);

    // 派工設定 - 獲取檢核表單資料、巡檢人員
    Route::get('/dispatchSet/getForm', [DispatchSetController::class , 'getForm']);
    // 派工設定 - 獲取選定的檢核表單基本資料
    Route::get('/dispatchSet/getDispatch', [DispatchSetController::class , 'getDispatch']);
    // 派工測試
    Route::get('/dispatchSet/getData', [DispatchSetController::class , 'getData']);


    // 巡檢紀錄 - 相關功能
    Route::post('/checkBankDetail/uploadPhotos', [CheckBankDetailController::class, 'uploadPhotos']);

    // 刪除照片(目前尚未使用到)
    Route::post('check-bank-detail/{check_detail_id}/{photo_id}', [CheckBankDetailController::class, 'removePhoto']);


    
    // 手機api
    // 檢核表單(基本資料、題目資料、)
    Route::get('check/allDate', [DownloadController::class, 'allDate']);

    // 巡檢表
    Route::get('check/daily/{date}' , [DownloadController::class, 'getList']);
    // 巡檢表下的題目資料 需分兩組，一組已經使用過(有暫存檔)、一組還未使用(新的)
    Route::get('check/detail/{check_id}', [DownloadController::class , 'getDetail']);
    // 上傳 (查看狀態、Detail、圖片)
    Route::get('check/checkState/{check_id}', [UploadController::class, 'checkState']);
    Route::post('check/newUpload/{check_id}', [UploadController::class , 'newUpload']);
    Route::post('check/uploadimg/{check_id}/{detail_id}', [UploadController::class , 'uploadimg']);
});
