# ChemBee

## 🚀 功能特點

- 使用 Tailwind CSS 的現代化界面
- 使用 Vue.js 3 進行前端開發
- Laravel 後端框架
- 使用 Vite 進行快速開發和構建
- Bootstrap 5 整合
- Cesium 3D 地圖功能
- Excel 導出功能
- JWT 身份驗證

## 📋 環境要求

在開始之前，請確保您已安裝以下軟件：
- PHP >= 8.1
- Composer
- Node.js >= 16
- npm 或 yarn
- PostgreSQL

## 🛠️ 安裝步驟

1. clone：
```bash
git clone [repository-url]
cd chembee
```

2. 安裝 PHP 依賴：
```bash
composer install
```

3. 安裝 JavaScript 依賴：
```bash
npm install
```

4. 創建環境配置文件：
```bash
cp .env.example .env

加入
APP_URL=http://chemical.localhost:8060/
ASSET_URL=/chembee
VITE_APP_ASSET_URL=/chembee
VITE_APP_SECRET_KEY=9e107d9d372bb6826bd81d3542a419d6
```

5. 生成應用密鑰：
```bash
php artisan key:generate
```

6. 在 `.env` 文件中配置數據庫：
```bash
DB_CONNECTION=DB_CONNECTION=pgsql
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=your_database
DB_USERNAME=your_username
DB_PASSWORD=your_password
```

7. 運行數據庫遷移：
```bash
php artisan migrate:refresh --seed
```

## 🚀 開發

啟動開發服務器：

```bash
# 啟動 Vite 開發服務器
npm run dev
```

應用將在 `http://localhost:8000` 上運行

## 🏗️ 生產環境構建

構建生產環境資源：

```bash
npm run build
```

## 📦 依賴項

### 前端
- Vue.js 3
- Tailwind CSS
- Bootstrap 5
- Cesium
- Pinia (狀態管理)
- Vue Router
- SweetAlert2

### 後端
- Laravel
- JWT 身份驗證
