<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Imports\HeadingRowFormatter;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithStyles;

HeadingRowFormatter::default('none');
class ChemicalErrorExport implements WithMultipleSheets
{
    private $sheetOneData;
    private $sheetTwoData;
    private $sheetThreeData;

    public function __construct($sheetOneData, $sheetTwoData, $sheetThreeData)
    {
        $this->sheetOneData = $sheetOneData;
        $this->sheetTwoData = $sheetTwoData;
        $this->sheetThreeData = $sheetThreeData;
    }

    public function sheets(): array
    {
        return [
            '購買資料' => new SheetOneExport($this->sheetOneData),
            '瓶編號' => new SheetTwoExport($this->sheetTwoData),
            '混合物質' => new SheetThreeExport($this->sheetThreeData),
        ];
    }
}
class SheetOneExport implements FromCollection, WithTitle,WithStyles
{
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return collect($this->data);
    }

    public function title(): string
    {
        return '購買資料';
    }
    public function styles(Worksheet $sheet)
    {
        return [
            'AB' => [
                'font' => [
                    'color' => ['argb' => 'FF0000'],
                ],
            ],
        ];
    }
}
class SheetTwoExport implements FromCollection, WithTitle
{
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return collect($this->data);
    }
    public function title(): string
    {
        return '瓶編號';
    }
}
class SheetThreeExport implements FromCollection, WithTitle
{
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        return collect($this->data);
    }
    public function title(): string
    {
        return '混合物質';
    }
}
