<?php
namespace App\Helpers;

use Illuminate\Support\Facades\Auth;

class UserHelper
{
    public static function getCompanyId(): ?int
    {
        $user = Auth::user();
        if (!$user) {
            return null;
        }

        return $user->role === 'company' ? $user->id : $user->belongs_parent;
    }
    public static function isCompanyRole(): ?int
    {
        $user = Auth::user();

        return $user && $user->role === 'company';

    }
}
