<?php

namespace App\Http\Controllers;

use App\Helpers\UserHelper;
use App\Http\Services\ApprovalDocService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ApprovalDocController extends Controller
{
    function __construct(protected ApprovalDocService $approval)
    {
        
    }

    public function all(){
        return $this->approval->all();
    }
    public function getSelectList(){
        $data = $this->approval->getSelectList();
        return response()->json($data);
    }

    public function docfind($id){
        //修改路徑
        $data = $this->approval->docfind($id);
        $data->file_path = config('app.asset_url') . Storage::url($data->file_path);
        return response()->json($data);
    }
    public function docCreate(Request $request){
        $create = $this->approval->docCreate($request);
        return response()->json([
            'message'=>'儲存成功',
            'doc_id'=>$create
        ],200);
    }

    public function docDelete(Request $request)
    {
        $ids = $request->ids;
        $this->approval->docDelete($ids);
        return response()->json([
            'message'=>'刪除成功'
        ],200);
    }
    public function docListCreate(Request $request){
        $this->approval->docListCreate($request);
        return response()->json([
            'message'=>'儲存成功'
        ],200);
    }

    public function docListUpdate(Request $request){
        $this->approval->docListUpdate($request);
        return response()->json([
            'message'=>'修改成功'
        ],200);
    }

    public function docListDelete($id)
    {
        $this->approval->docListDelete($id);
        return response()->json([
            'message'=>'刪除成功'
        ]);
    }

    public function manyChemFindDoc($id)
    {
        return $this->approval->manyChemFindDoc($id);
    }
}
