<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalBaseService;
use App\Http\Services\ChemicalReviewService;
use App\Http\Services\SdsBaseService;
use App\Imports\ChemicalImport;
use App\Imports\ChemicalImportToxic;
use App\Models\Chemical_review_sds;
use Carbon\Carbon;
use Exception;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class ChemicalBaseController extends Controller
{
    function __construct(protected ChemicalBaseService $chemical, protected SdsBaseService $sdsBase, protected ChemicalReviewService $Review) {}


    function store(Request $request)
    {

        $request->validate([
            'cas_no' => 'required|string|max:255',
            'ch_name' => 'nullable|string|max:255',
            'en_name' => 'required|string|max:255',
            'ChSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
            'ENSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
        ], [
            'cas_no.required' => '請填寫 CAS 編號。',
            'cas_no.string' => 'CAS 編號必須是文本格式。',
            'cas_no.max' => 'CAS 編號不能超過 255 個字元。',
            'ch_name.string' => '中文名稱必須是文本格式。',
            'ch_name.max' => '中文名稱不能超過 255 個字元。',
            'en_name.required' => '請填寫英文名稱。',
            'en_name.string' => '英文名稱必須是文本格式。',
            'en_name.max' => '英文名稱不能超過 255 個字元。',
            'ChSDS_id.*.file' => '請上傳有效的文件。',
            'ChSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc',
            'ENSDS_id.*.file' => '請上傳有效的文件。',
            'ENSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc',
        ]);





        $priorityMolList = $this->chemical->generateBitString($request, 'list_priority', 4);


        $toxicityClassificationList = $this->chemical->generateBitString($request, 'toxic_class', 4);

        $transIconList = $this->chemical->generateBitString($request, 'trans_icon', 22);

        $casno = trim($request->cas_no);

        $hascasno = $this->chemical->findcas($casno);

        if ($hascasno) {
            return response()->json([
                'message' => 'Cas No重複'
            ], 400);
        };
        $chemical = $this->chemical->store([
            'cas_no' => $casno,
            'created_user' => Auth::user()->id,
            'ch_name' => trim($request->ch_name),
            'en_name' =>str_replace(["\r","\n"],'',trim($request->en_name)) ,
            'hazards' => (int)$request->hazards,
            'priority' => (int)$request->priority,
            'list_priority' => $priorityMolList,
            'control' => (int)$request->control,
            'pioneer' => (int)$request->pioneer,
            'listNo' => (int)$request->listNo,
            'water_poll' => (int)$request->water_poll,
            'concerned' => (int)$request->concerned,
            'list_concerned' => (int)$request->list_concerned,
            'toxic_moenv' => (int)$request->toxic_moenv,
            'toxic_class' => $toxicityClassificationList,
            'conc' => $request->conc,
            'graded' => $request->graded,
            'boil' => $request->boil,
            'melt' => $request->melt,
            'formula' => $request->formula,
            'molecular' => $request->molecular,
            'ingredient' => $request->ingredient,
            'pub_hazard' => (int)$request->pub_hazard,
            'solv' => (int)$request->solv,
            'monitor' => (int)$request->monitor,
            'chem_spec' => (int)$request->chem_spec,
            'lead' => (int)$request->lead,
            'four_lead' => (int)$request->four_lead,
            'ccd_health' => (int)$request->ccd_health,
            'expose_conc' => (int)$request->expose_conc,
            'pel_solide' => $request->pel_solide,
            'pel_liquid' => $request->pel_liquid,
            'a201' => $request->a201,
            'a202' => $request->a202,
            'a203' => $request->a203,
            'a204' => $request->a204,
            'a205' => $request->a205,
            'a206' => $request->a206,
            'a207' => $request->a207,
            'a208' => $request->a208,
            'a209' => $request->a209,
            'a210' => $request->a210,
            'a211' => $request->a211,
            'a212' => $request->a212,
            'a213' => $request->a213,
            'a214' => $request->a214,
            'a215' => $request->a215,
            'a216' => $request->a216,
            'a217' => $request->a217,
            'a217a' => $request->a217a,
            'a217b' => $request->a217b,
            'a217c' => $request->a217c,
            'a218' => $request->a218,
            'a219' => $request->a219,
            'a220' => $request->a220,
            'a221' => $request->a221,
            'a222' => $request->a222,
            'a223' => $request->a223,
            'a224a' => $request->a224a,
            'a224b' => $request->a224b,
            'a225' => $request->a225,
            'a225a' => $request->a225a,
            'a226' => $request->a226,
            'a226a' => $request->a226a,
            'a227' => $request->a227,
            'a228' => $request->a228,
            'a229' => $request->a229,
            'transport_icon' => $transIconList,
            'created_at' => Carbon::now(),
            'updated_user' => Auth::user()->id,
            'danger'=>(int)$request->danger,
            'danger_volume'=>$request->danger_volume,
            'danger_unit'=>$request->danger_unit,
            'danger_name'=>$request->danger_name,
            'danger_class'=>$request->danger_class,
            'danger_water'=>(int)$request->danger_water,
        ]);

        if ($request->hasFile('ChSDS_id')) {

            $files = $request->file('ChSDS_id');

            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $filePath = $file->storeAs('public/SdsBase/ch/' . $casno . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $chemical,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'ch',
                ]);
            }
        }

        if ($request->hasFile('ENSDS_id')) {
            $files = $request->file('ENSDS_id');
            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $filePath = $file->storeAs('public/SdsReview/en/' . $casno . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $chemical,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'en',
                ]);
            }
        }

        return response()->json([
            'message' => '化學品資料新增成功',
            'chemical' => $chemical
        ], 200);
    }

    function search(Request $request)
    {
        $filters = $request->only(['cas_no', 'ch_name', 'en_name', 'property', 'review']);
        $list = $this->chemical->search($filters);
        return response()->json($list);
    }

    function show($id)
    {
        $chemical = $this->chemical->find($id);
        $chemical['cas_no'] = trim($chemical['cas_no']);
        $priority_array = str_split($chemical->list_priority);
        $priority_bool = array_map(function ($value) {
            return (bool) $value;
        }, $priority_array);

        foreach (range(1, 4) as $i) {
            $chemical['list_priority_' . $i] = $priority_bool[$i - 1];
        };

        $toxi_array = str_split($chemical->toxic_class);
        $toxi_bool = array_map(function ($value) {
            return (bool) $value;
        }, $toxi_array);

        foreach (range(1, 4) as $i) {
            $chemical['toxic_class_' . $i] = $toxi_bool[$i - 1];
        };

        $trans_array = str_split($chemical->transport_icon);
        $trans_bool = array_map(function ($value) {
            return (bool) $value;
        }, $trans_array);

        foreach (range(1, 22) as $i) {
            $chemical['trans_icon_' . $i] = $trans_bool[$i - 1];
        };

        $sdsBase = $chemical->SdsBase;
        if ($sdsBase === null) {
            $sdsBase = [];
        } else {
            $sdsBase = $sdsBase->toArray();
        }
        $filenames = array_column($sdsBase, 'name');

        $newfilenames = $this->chemical->processMultipleFilenames($filenames);

        $sdsBase = array_map(function ($item, $newName) {
            $item['name'] = $newName;
            $item['url'] = config('app.asset_url') . Storage::url($item['path']);
            return $item;
        }, $sdsBase, $newfilenames);

        $chemical->SdsBase = $sdsBase;

        return response()->json($chemical);
    }

    function update($id, Request $request)
    {
        $request->validate([
            'cas_no' => 'required|string|max:255',
            'ch_name' => 'nullable|string|max:255',
            'en_name' => 'required|string|max:255',
            'ChSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
            'ENSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
        ], [
            'cas_no.required' => '請填寫 CAS 編號。',
            'cas_no.string' => 'CAS 編號必須是文本格式。',
            'cas_no.max' => 'CAS 編號不能超過 255 個字元。',
            'ch_name.string' => '中文名稱必須是文本格式。',
            'ch_name.max' => '中文名稱不能超過 255 個字元。',
            'en_name.required' => '請填寫英文名稱。',
            'en_name.string' => '英文名稱必須是文本格式。',
            'en_name.max' => '英文名稱不能超過 255 個字元。',
            'ChSDS_id.file' => '請上傳有效的文件。',
            'ChSDS_id.*.file' => '請上傳有效的文件。',
            'ChSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc',
            'ENSDS_id.*.file' => '請上傳有效的文件。',
            'ENSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc',
        ]);
        $data = $request->all();
        // dd($data);
        // $data = array_map('trim', $request->all());
        // $data = array_filter($data, function($value) {
        //     return !is_null($value) && $value !== '';
        // });

        $data['list_priority'] = $this->chemical->generateBitString($request, 'list_priority', 4);
        $data['toxic_class'] = $this->chemical->generateBitString($request, 'toxic_class', 4);
        $data['transport_icon'] = $this->chemical->generateBitString($request, 'trans_icon', 22);
        $data['updated_user'] = Auth::user()->id;
        unset($data['created_user']);
        $cc = $this->chemical->find($id);
        $chemical_cas = trim($cc->cas_no);
        if ($request->cas_no !== $chemical_cas) {
            $existcas = $this->chemical->findcas($request->cas_no);
            if ($existcas) {
                return response()->json([
                    'message' => 'Cas No重複'
                ], 400);
            }
            $data['cas_no'] = $request->cas_no;
        } else {
            unset($data['cas_no']);
        }
        if ($request->hasFile('ChSDS_id')) {

            $files = $request->file('ChSDS_id');

            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $filePath = $file->storeAs('public/SdsBase/ch/' . $chemical_cas . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $id,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'ch',
                ]);
            }
        }

        if ($request->hasFile('ENSDS_id')) {
            $files = $request->file('ENSDS_id');
            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $filePath = $file->storeAs('public/SdsReview/en/' . $chemical_cas . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $id,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'en',
                ]);
            }
        }

        // $this->chemical->update($id, $data);
        try {
            $this->chemical->update($id, $data);
        } catch (QueryException $e) {
            return response()->json(['message' => '資料庫錯誤'], 500);
        } catch (\Exception $e) {
            return response()->json(['message' => '發生錯誤'], 500);
        }
        return response()->json([
            'message' => '化學品資料更新成功',
            'chemical' => $id
        ], 200);
    }

    function mutidelete(Request $request)
    {
        $ids = $request->input('ids');

        $this->chemical->destroy($ids);
        return response()->json([
            'message' => '化學品資料刪除成功'
        ], 200);
    }

    function agreereview(Request $request, $id)
    {

        $request->validate([
            'cas_no' => 'required|string|max:255',
            'ch_name' => 'nullable|string|max:255',
            'en_name' => 'required|string|max:255',
            'ChSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
            'ENSDS_id.*' => 'nullable|file|mimes:pdf,docx,doc',
        ], [
            'cas_no.required' => '請填寫 CAS 編號。',
            'cas_no.string' => 'CAS 編號必須是文本格式。',
            'cas_no.max' => 'CAS 編號不能超過 255 個字元。',
            'ch_name.string' => '中文名稱必須是文本格式。',
            'ch_name.max' => '中文名稱不能超過 255 個字元。',
            'en_name.required' => '請填寫英文名稱。',
            'en_name.string' => '英文名稱必須是文本格式。',
            'en_name.max' => '英文名稱不能超過 255 個字元。',
            'ChSDS_id.*.file' => '請上傳有效的文件。',
            'ChSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc。',
            'ENSDS_id.*.file' => '請上傳有效的文件。',
            'ENSDS_id.*.mimes' => '文件類型必須是 pdf, docx, doc',
        ]);
        $priorityMolList = $this->chemical->generateBitString($request, 'list_priority', 4);
        $toxicityClassificationList = $this->chemical->generateBitString($request, 'toxic_class', 4);
        $transIconList = $this->chemical->generateBitString($request, 'trans_icon', 22);
        $casno = trim($request->cas_no);
        $hascasno = $this->chemical->findcas($casno);
        if ($hascasno) {
            return response()->json([
                'message' => 'Cas No重複'
            ], 400);
        };
        $chemical = $this->chemical->store([
            'cas_no' => $casno,
            'created_user' => $id,
            'ch_name' => trim($request->ch_name),
            'en_name' => trim($request->en_name),
            'hazards' => (int)$request->hazards,
            'priority' => (int)$request->priority,
            'list_priority' => $priorityMolList,
            'control' => (int)$request->control,
            'pioneer' => (int)$request->pioneer,
            'listNo' => (int)$request->listNo,
            'water_poll' => (int)$request->water_poll,
            'concerned' => (int)$request->concerned,
            'list_concerned' => (int)$request->list_concerned,
            'toxic_moenv' => (int)$request->toxic_moenv,
            'toxic_class' => $toxicityClassificationList,
            'conc' => $request->conc,
            'graded' => $request->graded,
            'boil' => $request->boil,
            'melt' => $request->melt,
            'formula' => $request->formula,
            'molecular' => $request->molecular,
            'ingredient' => $request->ingredient,
            'pub_hazard' => (int)$request->pub_hazard,
            'solv' => (int)$request->solv,
            'monitor' => (int)$request->monitor,
            'chem_spec' => (int)$request->chem_spec,
            'lead' => (int)$request->lead,
            'four_lead' => (int)$request->four_lead,
            'ccd_health' => (int)$request->ccd_health,
            'expose_conc' => (int)$request->expose_conc,
            'pel_solide' => $request->pel_solide,
            'pel_liquid' => $request->pel_liquid,
            'a201' => $request->a201,
            'a202' => $request->a202,
            'a203' => $request->a203,
            'a204' => $request->a204,
            'a205' => $request->a205,
            'a206' => $request->a206,
            'a207' => $request->a207,
            'a208' => $request->a208,
            'a209' => $request->a209,
            'a210' => $request->a210,
            'a211' => $request->a211,
            'a212' => $request->a212,
            'a213' => $request->a213,
            'a214' => $request->a214,
            'a215' => $request->a215,
            'a216' => $request->a216,
            'a217' => $request->a217,
            'a217a' => $request->a217a,
            'a217b' => $request->a217b,
            'a217c' => $request->a217c,
            'a218' => $request->a218,
            'a219' => $request->a219,
            'a220' => $request->a220,
            'a221' => $request->a221,
            'a222' => $request->a222,
            'a223' => $request->a223,
            'a224a' => $request->a224a,
            'a224b' => $request->a224b,
            'a225' => $request->a225,
            'a225a' => $request->a225a,
            'a226' => $request->a226,
            'a226a' => $request->a226a,
            'a227' => $request->a227,
            'a228' => $request->a228,
            'a229' => $request->a229,
            'transport_icon' => $transIconList,
            'created_at' => Carbon::now(),
            'updated_user' => $this->Review->findcase($casno)->updated_user,
            'danger'=>(int)$request->danger,
            'danger_volume'=>$request->danger_volume,
            'danger_unit'=>$request->danger_unit,
            'danger_name'=>$request->danger_name,
            'danger_class'=>$request->danger_class,
            'danger_water'=>(int)$request->danger_water,
        ]);

        if ($request->hasFile('ChSDS_id')) {

            $files = $request->file('ChSDS_id');

            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $filePath = $file->storeAs('public/SdsBase/ch/' . $casno . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $chemical,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'ch',
                ]);
            }
        }

        if ($request->hasFile('ENSDS_id')) {
            $files = $request->file('ENSDS_id');
            if (!is_array($files)) {
                $files = [$files];
            }
            foreach ($files as $file) {
                $extension = substr($file->getClientOriginalName(), -3);
                $fileName = date('YmdHi') . '_' . $file->getClientOriginalName();
                $filePath = $file->storeAs('public/SdsBase/en/' . $casno . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx'));
                $this->sdsBase->store([
                    'chemical_id' => $chemical,
                    'name' => $file->getClientOriginalName(),
                    'path' => $filePath,
                    'language' => 'en',
                ]);
            }
        }

        $sdsReviews = Chemical_review_sds::where('chemical_id', $id)->get();

        if ($sdsReviews->isNotEmpty()) {
            $filenames = $sdsReviews->pluck('name')->toArray();
            $newfilenames = $this->chemical->processMultipleFilenames($filenames);

            foreach ($sdsReviews as $index => $sdsReview) {
                $extension = substr($newfilenames[$index], -3);
                $fileName = $casno . '_' . date('YmdHi') . '_' . Str::random(6). (strtolower($extension) ==='pdf'?'.pdf':'.docx');
                $relativePath = 'public/SdsBase/' . ($sdsReview->language === 'ch' ? 'ch/' : 'en/') . $fileName;
                $sourcePath = public_path('storage/SdsReview/' . ($sdsReview->language === 'ch' ? 'ch/' : 'en/') . $sdsReview->name);
                $destinationPath = public_path('storage/SdsBase/' . ($sdsReview->language === 'ch' ? 'ch/' : 'en/') . $fileName);
                $sdsBase = $this->sdsBase->store([
                    'chemical_id' => $chemical,
                    'path' => $relativePath,
                    'name' => $newfilenames[$index],
                    'language' => $sdsReview->language,
                ]);

                if (!file_exists(dirname($destinationPath))) {
                    mkdir(dirname($destinationPath), 0755, true);
                }
                if (file_exists($sourcePath)) {
                    copy($sourcePath, $destinationPath);
                }
            }
        }
        $stat = $this->Review->find($id);
        if ($stat) {
            $stat->review = '1';
            $stat->save();

            return response()->json([
                'message' => '已同意',
            ], 200);
        }
    }

    function importSDS(Request $request)
    {
        DB::beginTransaction(); // 開始交易

        try {
            $request->validate([
                'files.*' => 'required|file|mimes:pdf,docx|max:10240', // Limit to pdf, docx and max size 10MB
            ]);
            $totalSize = collect($request->file('files'))->sum(fn($file)=>$file->getSize());
            if($totalSize > 10 * 1024 * 1024){
                throw new Exception("檔案總共超過10MB", 400);
            }
            if ($request->hasFile('files')) {
                $Files = $request->file('files');
                foreach ($Files as $file) {
                    $fileName = $file->getClientOriginalName();
                    $parts = explode('_', $fileName);
                    if (count($parts) === 2 || count($parts) === 3) {
                        $cas_no = $parts[1];
                        $language = $parts[0];
                        $file_name = $parts[2] ?? '';
                        if ($file_name) {
                            $extension = explode('.', $parts[2]);
                            $saveFileName = $cas_no . '_' . date('YmdHi') . '_' . Str::random(6);
                            $filePath = $file->storeAs('public/SdsBase/' . ($language === 'ch' ? 'ch/' : 'en/') . $saveFileName . ($extension[1] === 'pdf' ? '.pdf' : '.docx'));
                            $chemicalId = $this->chemical->findcas($cas_no);
                        }else{
                            $extension = explode('.', $parts[1]);
                            $saveFileName = $extension[0] . '_' . date('YmdHi') . '_' . Str::random(6);
                            $filePath = $file->storeAs('public/SdsBase/' . ($language === 'ch' ? 'ch/' : 'en/') . $saveFileName . ($extension[1] === 'pdf' ? '.pdf' : '.docx'));
                            $chemicalId = $this->chemical->findcas($extension[0]);
                        }
                        
                        $this->sdsBase->store([
                            'chemical_id' => $chemicalId->id,
                            'path' => $filePath,
                            'name' => $file_name ? $file_name : $fileName,
                            'language' => $language,
                        ]);
                    } else {
                        throw new Exception("檔案名稱格式錯誤", 400);
                    }
                }
            }

            DB::commit(); // 提交交易
        } catch (Exception $e) {
            DB::rollBack(); // 發生錯誤時回滾交易
            throw $e;
        }
    }

    function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,csv',
        ]);
        Excel::import(new ChemicalImport, $request->file('file'));
    }

    function importToxic(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,csv',
        ]);
        Excel::import(new ChemicalImportToxic, $request->file('file'));
    }

    public function UserCasNo(Request $request): \Illuminate\Http\JsonResponse
    {
        $searchTerm = $request->input('q'); // 獲取模糊搜尋關鍵字
        // 獲取特定 CAS No. 列表，並將其轉換為陣列
        $specificCasNos = $request->input('cas_nos');
        $casNosArray = null;
        if (!empty($specificCasNos)) {
            $casNosArray = explode(',', $specificCasNos);
            $casNosArray = array_map('trim', $casNosArray); // 移除前後空白
        }

        // 呼叫 Service/Manager 層的函式，並傳遞兩個參數
        // 確保 `$this->chemical` 在 Controller 中被正確注入或初始化
        $data = $this->chemical->UserCasNo($searchTerm, $casNosArray); // 根據您的層次結構調整呼叫對象

        return response()->json($data);
    }
}
