<?php

namespace App\Http\Controllers;

use App\Helpers\UserHelper;
use App\Http\Requests\UserDecanChemRequest;
use App\Http\Services\ChemicalDecantService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalDecantController extends Controller
{
    function __construct(protected ChemicalDecantService $chem_decant){}

    function decantChem(UserDecanChemRequest $request,$id)
    {
        $validatedData = $request->validated();
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $this->chem_decant->dacentChem($validatedData,$id,$user);

        return response()->json([
            'message'=>'分裝成功'
        ]);
    }

    function getDecantOperate()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();
        $data = $this->chem_decant->getDecantOperate($user,$company_id);
        return $data;
    }
}
