<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalDisposalService;
use App\Models\Chemical;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalDisposalController extends Controller
{
    function __construct(protected ChemicalDisposalService $chem_disposal)
    {
        
    }

    public function getDisposal()
    {
        $user = Auth::user();

        return $this->chem_disposal->getDisposal($user);
    }
    public function getDisposalLog()
    {
        $user = Auth::user();

        return $this->chem_disposal->getDisposalLog($user);
    }

    public function getDisposalOperate()
    {
        $user = Auth::user();
        return $this->chem_disposal->getDisposalOperate($user);
    }
    public function disposal(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_disposal->disposal($id,$user);
        
        return response()->json([
            'message'=>'廢棄成功'
        ],200);
    }

    public function desposalRestore(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_disposal->restore($id,$user);

        return response()->json([
            'message'=>'還原成功'
        ],200);
    }
}
