<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalExportService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalExportController extends Controller
{
    function __construct(protected ChemicalExportService $chem_export)
    {
        
    }
    //取得異動紀錄
    public function getExportLog()
    {
        $user = Auth::user();

        return $this->chem_export->getExport($user);
    }

    public function getExportOperate()
    {
        $user = Auth::user();

        return $this->chem_export->getExportOperate($user);
    }

    //轉出操作
    public function export(Request $request)
    {
        $id = $request->input('id');

        $sup = $request->input('sup');

        $remark =$request->input('remark');

        $user = Auth::user();

        $this->chem_export->export($id,$sup,$user,$remark);
    }

    public function exportRestore(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_export->restore($id,$user);

        return response()->json([
            'message'=>'還原成功'
        ],200);
    }
}
