<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalReportService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalReportController extends Controller
{
    function __construct(protected ChemicalReportService $chem_report)
    {
        
    }

    public function getReportlist(Request $request)
    {
        $user = Auth::user();
        return $this->chem_report->getChemlist($user,$request);
    }

    public function getChemReport(Request $request)
    {
        $user = Auth::user();
        try {
            return $this->chem_report->getChemReport($request, $user);
        } catch (\Throwable $e) {
            return response()->json([
                'message' => '報表資料取得錯誤',
                'error' => $e->getMessage()
            ], 500);
        }
    }

}
