<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalResidualService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalResidualController extends Controller
{
    function __construct(protected ChemicalResidualService $chem_residual)
    {
        
    }

    public function getResidual(){
        $user = Auth::user();
        return $this->chem_residual->getResidual($user);
    }
    public function getResidualLog(){
        $user = Auth::user();
        return $this->chem_residual->getResidualLog($user);
    }

    public function Residual(Request $request){
        $ids = $request->input('id');
        $user = Auth::user();
        $this->chem_residual->Residual($ids,$user);

        return response()->json([
            'message'=>'退回成功'
        ],200);
    }

    public function residualRestore(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_residual->restore($id,$user);

        return response()->json([
            'message'=>'還原成功'
        ],200);
    }
}
