<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalSellService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalSellController extends Controller
{
    function __construct(protected ChemicalSellService $chem_sell)
    {
        
    }
    //取得異動紀錄
    public function getSellLog()
    {
        $user = Auth::user();

        return $this->chem_sell->getSell($user);
    }

    public function getSellOperate()
    {
        $user = Auth::user();

        return $this->chem_sell->getSellOperate($user);
    }

    //轉出操作
    public function sell(Request $request)
    {
        $id = $request->input('id');

        $sup = $request->input('sup');

        $remark = $request->input('remark');

        $user = Auth::user();

        $this->chem_sell->sell($id,$sup,$user,$remark);
    }

    public function sellRestore(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_sell->restore($id,$user);

        return response()->json([
            'message'=>'還原成功'
        ],200);
    }
}
