<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalShiftOutService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalShiftOutController extends Controller
{
    function __construct(protected ChemicalShiftOutService $chem_shiftout)
    {
        
    }
    //取得異動紀錄
    public function getShiftOutLog()
    {
        $user = Auth::user();

        return $this->chem_shiftout->getShiftOut($user);
    }

    public function getShiftOutOperate()
    {
        $user = Auth::user();

        return $this->chem_shiftout->getShiftOutOperate($user);
    }

    //轉出操作
    public function shiftOut(Request $request)
    {
        $id = $request->input('id');

        $sup = $request->input('sup');

        $remark = $request->input('remark');

        $user = Auth::user();

        $this->chem_shiftout->shiftOut($id,$sup,$user,$remark);
    }

    public function shiftOutRestore(Request $request)
    {
        $id = $request->input('id');
        $user = Auth::user();
        $this->chem_shiftout->restore($id,$user);

        return response()->json([
            'message'=>'還原成功'
        ],200);
    }
}
