<?php

namespace App\Http\Controllers;

use App\Helpers\UserHelper;
use App\Http\Requests\UserSubChemRequest;
use App\Http\Services\ChemicalSubService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalSubController extends Controller
{
    function __construct(protected ChemicalSubService $chemSub){}

    //使用搜尋欄位資料取得
    function getSearchSelect()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $data = $this->chemSub->getSearchSelect($company_id,$user);

        return $data;
    }
    //使用資料取得
    function getFactoryChem(Request $request)
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $data =  $this->chemSub->getFactoryChem($request,$user,$company_id);
        
        return response()->json($data);
    }
    //使用操作
    function subChem(UserSubChemRequest $request,$id){

        $validated = $request->validated();
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $result = $this->chemSub->subChem($validated,$id,$user,$company_id);

        return response()->json([
            'message'=>'使用成功'
        ],200);
    }
    //使用運作紀錄資料取得
    function getSubOperation()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();
        $data = $this->chemSub->getSubOperation($user,$company_id);
        return $data;
    }

    //運作使用記錄修改
    function subOperateUpdate(UserSubChemRequest $request,$id)
    {
        $validated = $request->validated();
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $result = $this->chemSub->subOperateUpdate($validated,$id,$user,$company_id);
        if(isset($result['error'])){
            $statusCode = $result['status_code'] ?? 400;
            return response()->json([
                'status' => 'error',
                'message' => $result['error']
            ], $statusCode); 
        }
        return response()->json([
            'message'=>'修改成功'
        ],200);
    }

    function getSubChange()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $data = $this->chemSub->getSubChange($user,$company_id);
        return $data;
    }

    function delOperate($id)
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $this->chemSub->delOperate($id,$user,$company_id);
    }
}
