<?php

namespace App\Http\Controllers;

use App\Http\Services\ChemicalTransferService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ChemicalTransferController extends Controller
{
    function __construct(protected ChemicalTransferService $chem_Transfer){}

    function getTransferOperate()
    {
        $user = Auth::user();
        return $this->chem_Transfer->getTransferOperate($user);
    }

    function chemTransferOperate(Request $request)
    {
        $user = Auth::user();
        $this->chem_Transfer->chemTransferOperate($request,$user);

        return response()->json([
            'message'=>'調撥成功'
        ]);

    }
}
