<?php

namespace App\Http\Controllers;

use App\Http\Services\DeclareService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx\Rels;

class DeclareController extends Controller
{
    function __construct(protected DeclareService $Declare)
    {
        
    }

    function getMoenvlist(Request $request){
        $user = Auth::user();
        return $this->Declare->getMoenvlist($user,$request);
    }

    function getDangerFactory(Request $request){
        $user = Auth::user();
        return response()->json($this->Declare->getDangerFactory($user,$request));
    }
    function getDangerlist(Request $request){
        $user = Auth::user();
        return response()->json($this->Declare->getDangerlist($user,$request));
    }

    public function getMoenvReport(Request $request)
    {
        $user = Auth::user();
        return $this->Declare->getMoenvReport($request,$user);
    }

    public function getIdaReport(Request $request)
    {
        $user = Auth::user();
        return $this->Declare->getIdaReport($request,$user);
    }
}
