<?php

namespace App\Http\Controllers;

use App\Helpers\UserHelper;
use App\Http\Services\StatisticsService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class StatisticsController extends Controller
{
    function __construct(protected StatisticsService $statist){}

    function getGraphData(Request $request){
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $data = $this->statist->getGraphData($user,$company_id,$request);
        return response()->json($data);
    }

    function getOperateData(Request $request){
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();

        $data = $this->statist->getOperateData($user,$company_id,$request);
        return response()->json($data);
    }
}
