<?php

namespace App\Http\Controllers;

use App\Helpers\UserHelper;
use App\Http\Services\SupplierService;
use App\Models\Supp;
use App\Models\Supply;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SupplierController extends Controller
{
    function __construct(protected SupplierService $sup) {}

    //取得公司底下所有廠商
    function supAll()
    {
        $data = $this->sup->supAll();
        return response()->json($data);
    }

    //儲存或修改廠商資料
    function supStore(Request $request)
    {
        $id = Auth::user()->id;
        $data = [
            'c_id' => UserHelper::getCompanyId(),
            'created_user' => $id,
            'country' => trim($request->country),
            'tax' => trim($request->tax),
            'No' => trim($request->No),
            'name' => trim($request->name),
            'address' => trim($request->address),
            'PIC' => trim($request->PIC),
            'POC' => trim($request->POC),
            'tel' => trim($request->tel),
            'fax' => trim($request->fax),
            'email' => trim($request->email),
            'updated_user' =>$id
        ];
        try {
            if ($request->id) {
                $id = $request->id;
                $data['updated_user'] = Auth::user()->id;
                unset($data['created_user']);
                $update = $this->sup->supUpdate($data, $id);

                return response()->json([
                    'message' => '修改成功'
                ], 200);
            } else {
                $data = $this->sup->supStore($data);
                return response()->json([
                    'message' => '建立成功',
                    'id' => $data
                ], 201);
            }
        } catch (\Exception $e) {
            return response()->json([
                'message' => '內部伺服器錯誤，請稍後再試',
                'error' => $e->getMessage()
            ], 500);
        }
    }
    //取得修改資料
    function getSupEdit($id){
        $user = auth()->user();
        // $findSup = $this->sup->findSup($id);

        // if($findSup->company_id !== $user->belongs_parent && $findSup->company_id !== $user->id)
        // {
        //     return response()->json(['error' => 'Unauthorized'], 403);
        // }
        return $this->sup->getSupEdit($id);
    }
    function supDestory(Request $request)
    {
        $ids = $request->input('ids');
        $this->authorizeUserToDelete($ids);
        $this->sup->supDestory($ids);

        return response()->json([
            'message' => '刪除成功'
        ], 204);
    }

    private function authorizeUserToDelete(array $ids)
    {
        $userId = Auth::user()->id;
        $company_id =UserHelper::getCompanyId();

        $datas = Supply::whereIn('id', $ids)->get();
        foreach ($datas as $data) {
            if ($data->created_user != $userId && $data->c_id != $company_id) {
                abort(403, '您無權刪除此資料');
            }
        }
    }
}
