<?php

namespace App\Http\Controllers;

use App\Exports\ChemicalErrorExport;
use App\Http\Requests\UserNewChemRequest;
use App\Http\Services\UserNewChemService;
use App\Imports\ChemicalOrdImport;
use App\Exports\FailedRowsExport;
use App\Helpers\UserHelper;
use App\Imports\FailedRowsExport as ImportsFailedRowsExport;
use Dotenv\Exception\ValidationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;
use Maatwebsite\Excel\Validators\ValidationException as ValidatorsValidationException;

class UserNewChemController extends Controller
{
    function __construct(protected UserNewChemService $chem) {}


    //新增化學品-取得表單input資訊
    function getInfo()
    {
        $user_id = Auth::user()->id;
        $company_id = UserHelper::getCompanyId();
        $data = $this->chem->getInfo($company_id, $user_id);
        return response()->json($data);
    }
    function getOrd()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();
        $data = $this->chem->getOrd($company_id, $user);

        return $data;
    }

    function getEditOrd($id)
    {
        $user_id = Auth::user()->id;
        $company_id = UserHelper::getCompanyId();
        $data = $this->chem->getInfo($company_id, $user_id);
        $result = $this->chem->getEditOrd($id);
        if (isset($result['error'])) {
            $statusCode = $result['status_code'] ?? 400;
            return response()->json([
                'status' => 'error',
                'message' => $result['error']
            ], $statusCode);
        }
        $resultArray = $result->toArray();
        $mergedData = array_merge($data, $resultArray);
        return response()->json($mergedData);
    }

    function getFactoryChem()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();
        return $this->chem->getFactoryChem($company_id, $user);
    }

    function get3DFactoryChenArea(Request $request){
        $area_id = $request->area_id;
        return $this->chem->get3DFactoryChemArea($area_id);
    }

    function get3DFactoryChenBuild(Request $request){
        $build_id = $request->build_id;
        return $this->chem->get3DFactoryChemBuild($build_id);
    }

    function get3DFactoryChenFloor(Request $request){
        $build_id = $request->build_id;
        $floor = $request->floor;
        return $this->chem->get3DFactoryChemFloor($build_id,$floor);
    }

    function getChemChange()
    {
        $user = Auth::user();
        $company_id = UserHelper::getCompanyId();
        return $this->chem->getChemChange($company_id, $user);
    }
    function chemAddStore(UserNewChemRequest $request)
    {
        $validated = $request->validated();
        $id = Auth::user()->id;
        $company_id = UserHelper::getCompanyId();
        $data = $this->chem->chemAddStore($validated, $id, $company_id);
        if (isset($data['error'])) {
            $statusCode = $data['status_code'] ?? 400;
            return response()->json([
                'status' => 'error',
                'message' => $data['error']
            ], $statusCode);
        }
        if (isset($validated['id'])) {
            return response()->json([
                'message' => '更新成功'
            ]);
        } else {
            return response()->json([
                'message' => '建立成功'
            ]);
        }
    }

    function chemAddDestory(Request $request)
    {
        $ids = $request->input('ids');
        $result = $this->chem->chemAddDestory($ids);

        if (isset($result['error'])) {
            return response()->json([
                'message' => $result['error']
            ], 400);
        }
        // elseif(isset($result['error']) && isset($result['invalid']))
        // {
        //     return response()->json([
        //         'message' =>strval($result['error']) . strval($result['invalid'])
        //     ], 400); 
        // }
        return response()->json([
            'message' => '刪除成功'
        ], 200);
    }
    function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx',
        ], [
            'file.mimes' => '檔案格式僅限於 xlsx',
        ]);

        $result = $this->chem->import($request);
        
        if ($result['status'] === 'error') {
            // 驗證失敗，下載錯誤檔案
            return Excel::download(
                new ChemicalErrorExport(
                    $result['ord'],
                    $result['serial'], 
                    $result['mix']
                ), 
                'processed_chemical_data.xlsx'
            );
        } elseif ($result['status'] === 'success') {
            // 匯入成功
            return response()->json([
                'message' => '匯入成功'
            ], 200);
        } else {
            // 執行失敗
            return response()->json([
                'message' => '匯入失敗：' . $result['message']
            ], 500);
        }
    }
}
