<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Illuminate\Support\Facades\Response;

class AuthenticateToken
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {

        $token = $request->header('Authorization');


        if (!$token) {
            return Response::json(['error' => 'Token not provided'], 401);
        }

        try {

            $token = str_replace('Bearer ', '', $token);


            $decoded = JWT::decode($token, new Key(env('JWT_SECRET'), 'HS256'));


            $request->attributes->set('user', (array) $decoded);

            return $next($request);
        } catch (\Exception $e) {
            
            return Response::json(['error' => 'Invalid token'], 401);
        }
    }
}

