<?php

namespace App\Http\Repositories;

use App\Helpers\UserHelper;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class AuthRepository
{
    function __construct(protected User $users) {}
    public function findCompanyByTokenData($data)
    {
        $users = User::where('uuid', $data)->exists();
        return $users;
    }

    function store(array $data, $belong = null)
    {

        $data['password'] = bcrypt($data['tax_number']);

        if ($belong) {
            $data['belongs_parent'] = $belong;
        } else {
            $data['belongs_parent'] = null;
        }
        $id =  $this->users->insertGetId($data);

        $user = $this->users->find($id);

        return $user;
    }

    public function findUser(string $uuid)
    {

        $user =  $this->users->where('uuid', $uuid)->first();

        return $user;
    }

    public function updateuser($data, $id)
    {
        $user = $this->users->find($id);
        $user->update((array)$data);
        return $user;
    }

    function getSupUser($company_id, $id)
    {
        if ($company_id !== $id) {
            return $this->users->where('id', $id)->select('id', 'name', 'contact_name','role')->get();
        } else {
            $user = $this->users->where(function ($query) use ($id) {
                $query->where('belongs_parent', $id)
                    ->where('role', '!=', 'company');
            })
                ->orWhere('id', $id)
                ->select('id', 'name', 'contact_name','role')
                ->get();
            return $user;
        }
    }

    function idGet($id)
    {
        return $this->users->find($id);
    }

    function getOperateUser($user)
    {
        $userId = UserHelper::getCompanyId();
        return $this->users->where(function ($query) use ($userId) {
            $query->where('belongs_parent', $userId)
                ->where('role', '!=', 'company');
        })
            ->orWhere('id', $userId)
            ->select('id', 'name', 'contact_name')
            ->get();
    }

    function getchildcompany($user)
    {
        $userId = UserHelper::getCompanyId();
        return
            $this->users->where('belongs_parent', $userId)
            ->where('role', '=', 'company')
            ->pluck('id')
            ->toArray();
    }

    function getchildcompanyForReport($user)
    {
        $userId = UserHelper::getCompanyId();
        return
            $this->users->where('belongs_parent', $userId)
            ->select('id', 'name', 'contact_name')
            ->where('role', '=', 'company')
            ->get();
    }

    function getOpUser($id)
    {
        return $this->users->select('name', 'contact_name', 'tax_number','phone')->where('id', $id)->first();
    }

    function chNameFind($name,$user){
        return $this->users
        ->where(function($query) {
            $companyId = UserHelper::getCompanyId();
            $query->where('belongs_parent', $companyId)
                ->orWhere('id', $companyId);
        })
        ->where('contact_name', $name)
        ->first();
    }
}
