<?php

namespace App\Http\Repositories;

use App\Helpers\UserHelper;
use App\Models\Chemical_ord;
use Illuminate\Support\Facades\Auth;

class ChemicalOrdRepository
{

    function __construct(protected Chemical_ord $ord, protected AuthRepository $auth) {}

    function getOrd($company_id, $user)
    {
        if ($user->role == 'company') {
            return $this->ord->where('company_id', $company_id)->orderby('add_date', 'desc')->get();
        } else {
            return $this->ord->where('custodian', $user->id)->orderby('add_date', 'desc')->get();
        }
    }

    function find($id)
    {
        $ord = $this->ord->where('id', $id)
            ->with([
                'factoryChem' => function ($query) {
                    $query->select('id', 'ord_id', 'serial_num', 'expired_date', 'parent_id')
                        ->whereNull('parent_id')
                        ->orderBy('serial_num', 'asc');
                },
                'chemMix',
            ])
            ->first();

        if ($ord) {
            $ord->load([
                'doc_list' => function ($query) use ($ord) {
                    $query->where('company_id', UserHelper::getCompanyId())
                        ->whereHas('doc', function ($q) use ($ord) {
                            $q->where('end_date', '>=', $ord->add_date)
                                ->where('start_date', '<=', $ord->add_date);
                        })
                        ->whereRaw('conc_low::double precision <= ?', [$ord->conc])
                        ->whereRaw('conc_up::double precision >= ?', [$ord->conc])
                        ->orderByRaw('(conc_up::double precision - conc_low::double precision) ASC')
                        ->limit(1);
                }
            ]);
        }
        return $ord;
    }
    function store($data)
    {
        $ordId = $this->ord->create($data);
        return $ordId;
    }
    function update($data)
    {
        unset($data['bottles']);
        unset($data['blends']);
        unset($data['factory_chem']);
        unset($data['chem_mix']);
        unset($data['oriblends']);
        unset($data['ord_id']);
        return $this->ord->where('id', $data['id'])->update($data);
    }

    function destory($id)
    {
        return $this->ord->where('id', $id)->delete();
    }
}
