<?php

namespace App\Http\Repositories;

use App\Models\Chemical_ord_log;
use Illuminate\Support\Facades\Auth;

class ChemicalOrdlLogRepository{

    function __construct(protected Chemical_ord_log $chem_change,protected AuthRepository $auth){}

    function getChemChange($company_id,$user)
    {
        $childcompany = $this->auth->getchildcompany($user);

        $query = $this->chem_change->with(
            'chemical_ord:id,chemical_name,chemical_other',
            'area:id,name',
            'build:id,name',
            'factories:id,name',
            'custodian:id,contact_name',
            'updated_user:id,contact_name'
        )->orderby('created_at', 'desc');
        if($user->id === $company_id)
        {
            $query->where('company_id',$company_id)->whereNotIn('custodian',$childcompany);
        }
        elseif($user->role === 'company' && $user->belongs_parnet === null){
            $query->where('custodian',$user->id);
        }
        else{
            $query->whereNotIn('custodian',$childcompany)->where('custodian',$user->id);
        }
        return  $query->get();
    }
    function Add($data)
    {
        return  $this->chem_change->create($data);
    }

    function del($data)
    {
        $operData = [
            'ord_id'=>$data->ord_id,
            'bottleCount'=>$data->bottleCount,
            'add_date'=>$data->add_date,
            'chemical_id'=>$data->chemical_id,
            'cas_no'=>$data->cas_no,
            'custodian'=>$data->custodian,
            'supplier_id'=>$data->supplier_id,
            'state'=>$data->state,
            'conc'=>$data->conc,
            'level'=>$data->level,
            'brand'=>$data->brand,
            'weight'=>$data->weight,
            'type'=>$data->ord_type,
            'factory_id'=>$data->factory_id,
            'build_id'=>$data->build_id,
            'area_id'=>$data->area_id,
            'company_id'=>$data->company_id,
            'updated_user'=>Auth::user()->id,
            'remark'=>$data->remark,
            'created_user'=>$data->created_user,
        ];
        return $this->chem_change->create($operData);
    }
}