<?php

namespace App\Http\Repositories;

// use App\Models\Chemical_base_inform;

use App\Models\Chemical_review;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ChemicalReviewRepository
{
    function __construct(protected Chemical_review $chemicalReview, protected User $users) {}

    function all()
    {
        return $this->chemicalReview->with('User','User.parent')->get();
    }

    function store($chemical)
    {
        return $this->chemicalReview->insertGetId($chemical);
    }

    function findcase($casno)
    {
        return $this->chemicalReview->where('cas_no',$casno)->first();
    }

    function find($id)
    {
        return $this->chemicalReview->with('User', 'SDSReview','User.parent')->find($id);
    }

    function update($id, $data)
    {
        return $this->chemicalReview->find($id)->update($data);
    }

    function destroy(array $ids)
    {
        $chemReviews = $this->chemicalReview->with('Chemical_review_sds')->whereIn('id',$ids)->get();

        foreach($chemReviews as $chemicalReview){

            $chemicalReview->SDSReview()->delete();

            $chemicalReview->delete();
        }

        return true;
    }

    function search()
    {

        // $query = $this->chemicalReview->query();
        // $query->leftJoin('user', DB::raw('CAST(chemical_reviews.created_user AS BIGINT)'), '=', 'user.id')
        // ->where('created_user', Auth::user()->id)
        // ->orWhere('belongs_parent', Auth::user()->uuid)
        // ->select('chemical_reviews.id','cas_no','ch_name','en_name','name','chemical_reviews.created_at','review');

        // return $query->orderBy('chemical_reviews.created_user', 'asc')->get();

        if (Auth::user()->role == 'company') {
            $company = User::Where('uuid', Auth::user()->uuid)->first();

            $child = $company->children()
                ->where('role', '!=', 'company')
                ->pluck('id');
            $query = $this->chemicalReview->query();
            $query->leftJoin('users', DB::raw('CAST(chemical_reviews.created_user AS BIGINT)'), '=', 'users.id')
                ->whereIn('created_user', $child)
                ->orWhere('created_user', Auth::user()->id)
                ->select('chemical_reviews.id', 'cas_no', 'ch_name', 'en_name', 'name', 'chemical_reviews.created_at', 'review');
            return $query->orderBy('chemical_reviews.created_user', 'asc')->get();
        } else {
            $uid = Auth::user()->uuid;
            $member = User::where('uuid', $uid)->first();
            $parentCompanyId = $member->parent ? $member->parent->id : null;
            $query = $this->chemicalReview->query();
            $query->leftJoin('users', DB::raw('CAST(chemical_reviews.created_user AS BIGINT)'), '=', 'users.id')
                // ->where('created_user', $parentCompanyId)
                ->orwhere('created_user', Auth::user()->id)
                ->select('chemical_reviews.id', 'cas_no', 'ch_name', 'en_name', 'name', 'chemical_reviews.created_at', 'review');

            return $query->orderBy('chemical_reviews.created_user', 'asc')->get();
        }

        // return response()->json($query->orderBy('id', 'asc')->get());
    }

    function companyID()
    {
        $uid = Auth::user()->uuid;
        $member = User::where('uuid', $uid)->first();
        if($member->role ==='company'){
            $parentCompanyId = $member->id;
        }else{
            $parentCompanyId = $member->belongs_parent;
        }

        return $parentCompanyId;
    }
}
