<?php

namespace App\Http\Repositories;

use App\Helpers\UserHelper;
use App\Models\Chemical_Sell_log;

class ChemicalSellLogRepository{
    function __construct(protected Chemical_Sell_log $chem_Sell_log,protected AuthRepository $auth){}


    function getSellLog($user)
    {
        $childcompany = $this->auth->getchildcompany($user);
        $company_id = UserHelper::getCompanyId();
        $query = $this->chem_Sell_log->with(
            'area:id,name',
            'build:id,name',
            'factories:id,name',
            'custodian:id,contact_name',
            'updated_user:id,contact_name'
        );
        if ($user->id === $company_id) {
            return $query->whereNotIn('custodian',$childcompany)->where('company_id', $company_id)->orderby('created_at', 'desc')->get();
        }
        elseif($user->role === 'company' && $user->belongs_parent !== null)
        {
            return $query->where('custodian', $user->id)->orderby('created_at', 'desc')->get();
        }  
        else {
            return $query->whereNotIn('custodian',$childcompany)->where('custodian', $user->id)->orderby('created_at', 'desc')->get();
        }
    }
    function create($data)
    {
        $this->chem_Sell_log->create($data);
    }
}