<?php

namespace App\Http\Repositories;

use App\Models\Chemical_sub_log;

class ChemicalSubLogRepository{
    function __construct(protected Chemical_sub_log $sub_change, protected AuthRepository $auth){}


    function getSubChange($user, $company_id)
    {
        $childcompany = $this->auth->getchildcompany($user);
        $query = $this->sub_change->with(
            'fact_chem:id,chemical_name,chemical_other',
            'area:id,name',
            'build:id,name',
            'factories:id,name',
            'custodian:id,contact_name',
            'updated_user:id,contact_name'
        );
        if ($user->id === $company_id) {
            return $query->whereNotIn('custodian',$childcompany)->where('company_id', $company_id)->orderby('created_at', 'desc')->get();
        } 
        elseif($user->role === 'company' && $user->belongs_parent !== null)
        {
            return $query->where('custodian', $user->id)->orderby('created_at', 'desc')->get();
        } 
        else {
            return $query->whereNotIn('custodian',$childcompany)->where('custodian', $user->id)->orderby('created_at', 'desc')->get();
        }
    }
    function create($data)
    {
        $this->sub_change->create($data);
    }

}